/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;

public class CacheHelper {
    private CacheHelper() {
    }

    public static <T> T withinTx(TransactionManager tm, Callable<T> c) throws Exception {
        tm.begin();
        try {
            T t = c.call();
            return t;
        }
        catch (Exception e) {
            tm.setRollbackOnly();
            throw e;
        }
        finally {
            if (tm.getStatus() == 0) {
                tm.commit();
            } else {
                tm.rollback();
            }
        }
    }
}

