/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.configadmin.parser;

import java.util.TreeSet;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.configadmin.parser.Namespace;
import org.jboss.as.configadmin.parser.Namespace10;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

class ConfigAdminWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    static ConfigAdminWriter INSTANCE = new ConfigAdminWriter();

    private ConfigAdminWriter() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        if (this.has(node, "configuration")) {
            ModelNode configuration = node.get("configuration");
            for (String pid : new TreeSet(configuration.keys())) {
                writer.writeStartElement(Namespace10.Element.CONFIGURATION.getLocalName());
                writer.writeAttribute(Namespace10.Attribute.PID.getLocalName(), pid);
                ModelNode entries = configuration.get(pid).get("entries");
                if (entries.isDefined()) {
                    for (String propKey : entries.keys()) {
                        String propValue = entries.get(propKey).asString();
                        writer.writeStartElement(Namespace10.Element.PROPERTY.getLocalName());
                        writer.writeAttribute(Namespace10.Attribute.NAME.getLocalName(), propKey);
                        writer.writeAttribute(Namespace10.Attribute.VALUE.getLocalName(), propValue);
                        writer.writeEndElement();
                    }
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private boolean has(ModelNode node, String name) {
        if (node.has(name) && node.get(name).isDefined()) {
            ModelNode n = node.get(name);
            switch (n.getType()) {
                case LIST: 
                case OBJECT: {
                    return n.asList().size() > 0;
                }
            }
            return true;
        }
        return false;
    }
}

