/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.TransactionManagerProvider;
import org.jboss.as.clustering.infinispan.TransactionSynchronizationRegistryProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class CacheConfigurationService
implements Service<Configuration> {
    private final String name;
    private final ConfigurationBuilder builder;
    private final Dependencies dependencies;
    private volatile Configuration config;
    private static final Logger log = Logger.getLogger((String)CacheConfigurationService.class.getPackage().getName());

    public static ServiceName getServiceName(String container, String cache) {
        return CacheService.getServiceName(container, cache).append(new String[]{"config"});
    }

    public CacheConfigurationService(String name, ConfigurationBuilder builder, Dependencies dependencies) {
        this.name = name;
        this.builder = builder;
        this.dependencies = dependencies;
    }

    public Configuration getValue() {
        return this.config;
    }

    public void start(StartContext context) throws StartException {
        TransactionSynchronizationRegistry tsr;
        EmbeddedCacheManager container = this.dependencies.getCacheContainer();
        this.builder.jmxStatistics().enabled(container.getCacheManagerConfiguration().globalJmxStatistics().enabled());
        TransactionManager tm = this.dependencies.getTransactionManager();
        if (tm != null) {
            this.builder.transaction().transactionManagerLookup((TransactionManagerLookup)new TransactionManagerProvider(tm));
        }
        if ((tsr = this.dependencies.getTransactionSynchronizationRegistry()) != null) {
            this.builder.transaction().transactionSynchronizationRegistryLookup((TransactionSynchronizationRegistryLookup)new TransactionSynchronizationRegistryProvider(tsr));
        }
        this.config = this.builder.build();
        CacheMode mode = this.config.clustering().cacheMode();
        if (mode.isClustered() && container.getTransport() == null) {
            throw InfinispanMessages.MESSAGES.transportRequired(mode, this.name, container.getCacheManagerConfiguration().globalJmxStatistics().cacheManagerName());
        }
        container.defineConfiguration(this.name, this.config);
        log.debugf("%s cache configuration started", (Object)this.name);
    }

    public void stop(StopContext context) {
        this.config = null;
        log.debugf("%s cache configuration stopped", (Object)this.name);
    }

    static interface Dependencies {
        public EmbeddedCacheManager getCacheContainer();

        public TransactionManager getTransactionManager();

        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry();
    }
}

