/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.deployment.processors.merging;

import java.util.List;
import java.util.Map;
import org.jboss.as.ejb3.EjbLogger;
import org.jboss.as.ejb3.EjbMessages;
import org.jboss.as.ejb3.deployment.ApplicationExceptionDescriptions;
import org.jboss.as.ejb3.deployment.ApplicationExceptions;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.ejb3.deployment.EjbDeploymentMarker;
import org.jboss.as.ejb3.tx.ApplicationExceptionDetails;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.ClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.metadata.ejb.spec.ApplicationExceptionMetaData;
import org.jboss.metadata.ejb.spec.ApplicationExceptionsMetaData;
import org.jboss.metadata.ejb.spec.AssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;

public class ApplicationExceptionMergingProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ApplicationExceptionsMetaData ddAppExceptions;
        AssemblyDescriptorMetaData assemblyDescriptor;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!EjbDeploymentMarker.isEjbDeployment(deploymentUnit)) {
            return;
        }
        List accessibleSubDeployments = (List)deploymentUnit.getAttachment(Attachments.ACCESSIBLE_SUB_DEPLOYMENTS);
        DeploymentClassIndex classIndex = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        ApplicationExceptions applicationExceptions = new ApplicationExceptions();
        for (DeploymentUnit unit : accessibleSubDeployments) {
            ApplicationExceptionDescriptions exceptionDescriptions = (ApplicationExceptionDescriptions)unit.getAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DESCRIPTIONS);
            if (exceptionDescriptions == null) continue;
            for (Map.Entry<String, ApplicationExceptionDetails> exception : exceptionDescriptions.getApplicationExceptions().entrySet()) {
                try {
                    ClassIndex index = classIndex.classIndex(exception.getKey());
                    applicationExceptions.addApplicationException(index.getModuleClass(), exception.getValue());
                }
                catch (ClassNotFoundException e) {
                    EjbLogger.ROOT_LOGGER.debug("Could not load application exception class", e);
                }
            }
        }
        EjbJarMetaData ejbJarMetaData = (EjbJarMetaData)deploymentUnit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMetaData != null && (assemblyDescriptor = ejbJarMetaData.getAssemblyDescriptor()) != null && (ddAppExceptions = assemblyDescriptor.getApplicationExceptions()) != null && !ddAppExceptions.isEmpty()) {
            for (ApplicationExceptionMetaData applicationException : ddAppExceptions) {
                String exceptionClassName = applicationException.getExceptionClass();
                try {
                    ClassIndex index = classIndex.classIndex(exceptionClassName);
                    boolean rollback = applicationException.isRollback();
                    boolean inherited = applicationException.isInherited() == null ? true : applicationException.isInherited();
                    applicationExceptions.addApplicationException(index.getModuleClass(), new ApplicationExceptionDetails(exceptionClassName, inherited, rollback));
                }
                catch (ClassNotFoundException e) {
                    throw EjbMessages.MESSAGES.failToLoadAppExceptionClassInEjbJarXml(exceptionClassName, e);
                }
            }
        }
        deploymentUnit.putAttachment(EjbDeploymentAttachmentKeys.APPLICATION_EXCEPTION_DETAILS, (Object)applicationExceptions);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

