/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStorageState;
import org.jboss.osgi.framework.internal.BundleValidatorR3;
import org.jboss.osgi.framework.internal.BundleValidatorR4;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.NativeCodePlugin;
import org.jboss.osgi.framework.internal.ResolverPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

abstract class UserBundleInstalledService<T extends UserBundleState>
extends AbstractBundleService<T> {
    private final Deployment initialDeployment;
    private T bundleState;

    UserBundleInstalledService(FrameworkState frameworkState, Deployment dep) {
        super(frameworkState);
        this.initialDeployment = dep;
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        Deployment dep = this.initialDeployment;
        BundleStorageState storageState = null;
        try {
            this.bundleState = this.createBundleState(dep);
            dep.addAttachment(Bundle.class, this.bundleState);
            OSGiMetaData metadata = (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
            storageState = ((UserBundleState)this.bundleState).createStorageState(dep);
            ((UserBundleState)this.bundleState).createResolverModule(dep);
            ((UserBundleState)this.bundleState).createRevision(dep);
            ((UserBundleState)this.bundleState).initUserBundleState(metadata);
            this.validateBundle((UserBundleState)this.bundleState, metadata);
            this.processNativeCode((UserBundleState)this.bundleState, dep);
            this.getBundleManager().addBundle((AbstractBundleState)this.bundleState);
            ((AbstractBundleState)this.bundleState).changeState(2, 0);
            this.addToResolver((UserBundleState)this.bundleState);
            ((AbstractBundleState)this.bundleState).fireBundleEvent(1);
        }
        catch (BundleException ex) {
            if (storageState != null) {
                storageState.deleteBundleStorage();
            }
            throw new StartException((Throwable)ex);
        }
    }

    abstract T createBundleState(Deployment var1);

    @Override
    T getBundleState() {
        return this.bundleState;
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.getBundleManager().uninstallBundle((UserBundleState)this.getBundleState(), 1);
    }

    private void validateBundle(UserBundleState userBundle, OSGiMetaData metadata) throws BundleException {
        if (metadata.getBundleManifestVersion() > 1) {
            new BundleValidatorR4().validateBundle(userBundle, metadata);
        } else {
            new BundleValidatorR3().validateBundle(userBundle, metadata);
        }
    }

    private void processNativeCode(UserBundleState userBundle, Deployment dep) {
        OSGiMetaData metadata = userBundle.getOSGiMetaData();
        if (metadata.getBundleNativeCode() != null) {
            FrameworkState frameworkState = userBundle.getFrameworkState();
            NativeCodePlugin nativeCodePlugin = frameworkState.getNativeCodePlugin();
            nativeCodePlugin.deployNativeCode(dep);
        }
    }

    private void addToResolver(UserBundleState userBundle) {
        if (userBundle.isSingleton()) {
            String symbolicName = this.getBundleState().getSymbolicName();
            for (AbstractBundleState aux : this.getBundleManager().getBundles(symbolicName, null)) {
                if (aux == userBundle || !aux.isSingleton()) continue;
                log.infof("No resolvable singleton bundle: %s", (Object)this);
                return;
            }
        }
        FrameworkState frameworkState = userBundle.getFrameworkState();
        ResolverPlugin resolverPlugin = frameworkState.getResolverPlugin();
        XModule resModule = userBundle.getResolverModule();
        resolverPlugin.addModule(resModule);
    }
}

