/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.PathDescription;
import org.jboss.as.controller.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;

public class PathRemoveHandler
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    private final boolean services;
    public static final PathRemoveHandler NAMED_INSTANCE = new PathRemoveHandler(false);
    public static PathRemoveHandler SPECIFIED_INSTANCE = new PathRemoveHandler(true);
    public static PathRemoveHandler SPECIFIED_NO_SERVICES_INSTANCE = new PathRemoveHandler(false);

    public static ModelNode getRemovePathOperation(ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        return op;
    }

    protected PathRemoveHandler(boolean services) {
        this.services = services;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return PathDescription.getPathRemoveOperation(locale);
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return this.services;
    }

    @Override
    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        context.removeService(AbstractPathService.pathNameOf(name));
    }
}

