/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.graphene.javascript;

import java.lang.reflect.Method;
import org.jboss.arquillian.graphene.javascript.JSInterface;
import org.jboss.arquillian.graphene.javascript.MethodName;

public class JSMethod {
    private JSInterface target;
    private Method method;
    private String name;

    public JSMethod(JSInterface target, Method method) {
        this.target = target;
        this.method = method;
        this.name = this.resolveName(method);
    }

    public JSInterface getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "JSMethod [method=" + this.method.getName() + ", name=" + this.name + ", target=" + this.target + "]";
    }

    private String resolveName(Method method) {
        MethodName annotation = method.getAnnotation(MethodName.class);
        if (annotation != null && !"".equals(annotation.value())) {
            return annotation.value();
        }
        return method.getName();
    }
}

