/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.tomcat.LogoutHandler;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogoutHandler
implements LogoutHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String redirectUrl;

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    @Override
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        Assertion assertion;
        this.logger.debug("Processing logout request from CAS server.");
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && (assertion = (Assertion)httpSession.getAttribute("_const_cas_assertion_")) != null) {
            httpSession.removeAttribute("_const_cas_assertion_");
            this.logger.info("Successfully logged out {}", (Object)assertion.getPrincipal());
        } else {
            this.logger.info("Session already ended.");
        }
        String redirectUrl = this.constructRedirectUrl(request);
        if (redirectUrl != null) {
            this.logger.debug("Redirecting to {}", (Object)redirectUrl);
            CommonUtils.sendRedirect((HttpServletResponse)response, (String)redirectUrl);
        }
    }

    protected String constructRedirectUrl(HttpServletRequest request) {
        return this.redirectUrl;
    }
}

