/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_290345e.core.internal.flow;

import java.util.BitSet;
import org.jacoco.agent.rt.internal_290345e.asm.tree.AbstractInsnNode;

public class Instruction {
    private final AbstractInsnNode node;
    private final int line;
    private int branches;
    private final BitSet coveredBranches;
    private Instruction predecessor;
    private int predecessorBranch;

    public Instruction(AbstractInsnNode node, int line) {
        this.node = node;
        this.line = line;
        this.branches = 0;
        this.coveredBranches = new BitSet();
    }

    public AbstractInsnNode getNode() {
        return this.node;
    }

    public void addBranch() {
        ++this.branches;
    }

    public void setPredecessor(Instruction predecessor, int branch) {
        this.predecessor = predecessor;
        predecessor.addBranch();
        this.predecessorBranch = branch;
    }

    public void setCovered(int branch) {
        Instruction i = this;
        int b = branch;
        while (i != null) {
            if (!i.coveredBranches.isEmpty()) {
                i.coveredBranches.set(b);
                break;
            }
            i.coveredBranches.set(b);
            b = i.predecessorBranch;
            i = i.predecessor;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getBranches() {
        return this.branches;
    }

    public int getCoveredBranches() {
        return this.coveredBranches.cardinality();
    }

    public void merge(Instruction instruction) {
        this.coveredBranches.or(instruction.coveredBranches);
    }

    public String toString() {
        return this.coveredBranches.toString();
    }
}

