/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.SaslUtils;
import net.spy.memcached.compat.SpyThread;
import net.spy.memcached.compat.log.Level;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.SASLMechsOperation;

public class BinaryAuthThread
extends SpyThread {
    public static final int AUTH_ROUNDTRIP_THRESHOLD = 250;
    public static final int AUTH_TOTAL_THRESHOLD = 1000;
    public static final String MECH_SEPARATOR = " ";
    private final MemcachedConnection conn;
    private final AuthDescriptor authDescriptor;
    private final OperationFactory opFact;
    private final MemcachedNode node;

    public BinaryAuthThread(MemcachedConnection c, OperationFactory o, AuthDescriptor a, MemcachedNode n) {
        this.conn = c;
        this.opFact = o;
        this.authDescriptor = a;
        this.node = n;
        this.start();
    }

    protected String[] listSupportedSASLMechanisms(AtomicBoolean done) {
        final CountDownLatch listMechsLatch = new CountDownLatch(1);
        final AtomicReference supportedMechs = new AtomicReference();
        SASLMechsOperation listMechsOp = this.opFact.saslMechs(new OperationCallback(){

            @Override
            public void receivedStatus(OperationStatus status) {
                if (status.isSuccess()) {
                    supportedMechs.set(status.getMessage());
                    BinaryAuthThread.this.getLogger().debug("Received SASL supported mechs: " + status.getMessage());
                } else {
                    BinaryAuthThread.this.getLogger().warn("Received non-success response for SASL mechs: " + status);
                }
            }

            @Override
            public void complete() {
                listMechsLatch.countDown();
            }
        });
        this.conn.insertOperation(this.node, listMechsOp);
        try {
            if (!this.conn.isShutDown()) {
                listMechsLatch.await();
            } else {
                done.set(true);
            }
        }
        catch (InterruptedException ex) {
            this.getLogger().warn("Interrupted in Auth while waiting for SASL mechs.");
            Thread.currentThread().interrupt();
            listMechsOp.cancel();
            done.set(true);
        }
        String supported = (String)supportedMechs.get();
        if (supported == null || supported.isEmpty()) {
            return null;
        }
        return supported.split(MECH_SEPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SaslClient saslClient;
        final AtomicBoolean done = new AtomicBoolean();
        long totalStart = System.nanoTime();
        long mechsStart = System.nanoTime();
        String[] supportedMechs = this.authDescriptor.getMechs() == null || this.authDescriptor.getMechs().length == 0 ? this.listSupportedSASLMechanisms(done) : this.authDescriptor.getMechs();
        long mechsDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - mechsStart);
        String msg = String.format("SASL List Mechanisms took %dms on %s", mechsDiff, this.node.toString());
        Level level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
        this.getLogger().log(level, msg);
        if (supportedMechs == null || supportedMechs.length == 0) {
            this.getLogger().warn("Authentication failed to " + this.node.getSocketAddress() + ", got empty SASL auth mech list.");
            throw new IllegalStateException("Got empty SASL auth mech list.");
        }
        String serverName = this.authDescriptor.getServerName();
        if (serverName == null) {
            serverName = this.node.getSocketAddress().toString();
        }
        try {
            saslClient = SaslUtils.createSaslClient(supportedMechs, null, "memcached", serverName, this.authDescriptor.getProperties(), this.authDescriptor.getCallback(), this.authDescriptor.getProviders());
        }
        catch (SaslException e) {
            throw new RuntimeException("Error initializing SASL client", e);
        }
        OperationStatus priorStatus = null;
        while (!done.get()) {
            long stepDiff;
            long stepStart = System.nanoTime();
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference foundStatus = new AtomicReference();
            OperationCallback cb = new OperationCallback(){

                @Override
                public void receivedStatus(OperationStatus val) {
                    if (val.getMessage().length() == 0) {
                        done.set(true);
                        BinaryAuthThread.this.node.authComplete();
                        BinaryAuthThread.this.getLogger().info("Authenticated to " + BinaryAuthThread.this.node.getSocketAddress());
                    } else {
                        foundStatus.set(val);
                    }
                }

                @Override
                public void complete() {
                    latch.countDown();
                }
            };
            Operation op = this.buildOperation(priorStatus, cb, saslClient);
            this.conn.insertOperation(this.node, op);
            try {
                if (!this.conn.isShutDown()) {
                    latch.await();
                } else {
                    done.set(true);
                }
                Thread.sleep(100L);
                stepDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stepStart);
            }
            catch (InterruptedException e) {
                try {
                    Thread.currentThread().interrupt();
                    if (op != null) {
                        op.cancel();
                    }
                    done.set(true);
                    stepDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stepStart);
                }
                catch (Throwable throwable) {
                    long stepDiff2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stepStart);
                    msg = String.format("SASL Step took %dms on %s", stepDiff2, this.node);
                    level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
                    this.getLogger().log(level, msg);
                    throw throwable;
                }
                msg = String.format("SASL Step took %dms on %s", stepDiff, this.node);
                level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
                this.getLogger().log(level, msg);
            }
            msg = String.format("SASL Step took %dms on %s", stepDiff, this.node);
            level = mechsDiff >= 250L ? Level.WARN : Level.DEBUG;
            this.getLogger().log(level, msg);
            if ((priorStatus = (OperationStatus)foundStatus.get()) == null || priorStatus.isSuccess()) continue;
            this.getLogger().warn("Authentication failed to " + this.node.getSocketAddress() + ", Status: " + priorStatus);
        }
        try {
            saslClient.dispose();
        }
        catch (SaslException e) {
            throw new RuntimeException("Error while disposing SASL", e);
        }
        long totalDiff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - totalStart);
        msg = String.format("SASL Auth took %dms on %s", totalDiff, this.node);
        level = mechsDiff >= 1000L ? Level.WARN : Level.DEBUG;
        this.getLogger().log(level, msg);
    }

    private Operation buildOperation(OperationStatus st, OperationCallback cb, SaslClient sc) {
        if (st == null) {
            return this.opFact.saslAuth(sc, cb);
        }
        return this.opFact.saslStep(sc, KeyUtil.getKeyBytes(st.getMessage()), cb);
    }
}

