/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl;

import org.hibernate.search.engine.backend.types.Projectable;
import org.hibernate.search.engine.backend.types.Searchable;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBinderRef;
import org.hibernate.search.mapper.pojo.bridge.mapping.annotation.ValueBridgeRef;
import org.hibernate.search.mapper.pojo.extractor.mapping.annotation.ContainerExtraction;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.VectorField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.PropertyMappingAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.processing.impl.AbstractFieldAnnotationProcessor;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingFieldOptionsStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingStep;
import org.hibernate.search.mapper.pojo.mapping.definition.programmatic.PropertyMappingVectorFieldOptionsStep;

public class VectorFieldAnnotationProcessor
extends AbstractFieldAnnotationProcessor<VectorField>
implements PropertyMappingAnnotationProcessor<VectorField> {
    @Override
    PropertyMappingFieldOptionsStep<?> initFieldMappingContext(PropertyMappingStep mappingContext, VectorField annotation, String fieldName) {
        String indexNullAs;
        Searchable searchable;
        Projectable projectable;
        VectorSimilarity vectorSimilarity;
        int efConstruction;
        int dimension = annotation.dimension();
        PropertyMappingVectorFieldOptionsStep fieldContext = dimension == Integer.MIN_VALUE ? mappingContext.vectorField(fieldName) : mappingContext.vectorField(dimension, fieldName);
        int m = annotation.m();
        if (m != Integer.MIN_VALUE) {
            fieldContext.m(m);
        }
        if ((efConstruction = annotation.efConstruction()) != Integer.MIN_VALUE) {
            fieldContext.efConstruction(efConstruction);
        }
        if (!VectorSimilarity.DEFAULT.equals((Object)(vectorSimilarity = annotation.vectorSimilarity()))) {
            fieldContext.vectorSimilarity(vectorSimilarity);
        }
        if (!Projectable.DEFAULT.equals((Object)(projectable = annotation.projectable()))) {
            fieldContext.projectable(projectable);
        }
        if (!Searchable.DEFAULT.equals((Object)(searchable = annotation.searchable()))) {
            fieldContext.searchable(searchable);
        }
        if ((indexNullAs = annotation.indexNullAs()) != null && !"__HibernateSearch_indexNullAs_default".equals(indexNullAs)) {
            fieldContext.indexNullAs(indexNullAs);
        }
        return fieldContext;
    }

    @Override
    ContainerExtraction getExtraction(VectorField annotation) {
        return annotation.extraction();
    }

    @Override
    String getName(VectorField annotation) {
        return annotation.name();
    }

    @Override
    ValueBridgeRef getValueBridge(VectorField annotation) {
        return annotation.valueBridge();
    }

    @Override
    ValueBinderRef getValueBinder(VectorField annotation) {
        return annotation.valueBinder();
    }
}

