/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.function.Supplier;
import org.hibernate.search.engine.backend.common.spi.EntityReferenceFactory;
import org.hibernate.search.engine.backend.mapping.spi.BackendMappingContext;
import org.hibernate.search.engine.backend.schema.management.spi.IndexSchemaManager;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.engine.backend.work.execution.spi.IndexWorkspace;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverRootContext;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoReindexingCollector;
import org.hibernate.search.mapper.pojo.bridge.RoutingBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.NoOpDocumentRouter;
import org.hibernate.search.mapper.pojo.mapping.impl.RoutingBridgeDocumentRouter;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.CachingCastingEntitySupplier;
import org.hibernate.search.mapper.pojo.work.impl.PojoDocumentContributor;
import org.hibernate.search.mapper.pojo.work.impl.PojoIndexedTypeIndexingPlan;
import org.hibernate.search.mapper.pojo.work.impl.PojoTypeIndexer;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkIndexedTypeContext;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkRouter;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkSessionContext;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeAppendable;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoIndexedTypeManager<I, E>
implements AutoCloseable,
ToStringTreeAppendable,
PojoWorkIndexedTypeContext<I, E>,
PojoScopeIndexedTypeContext<I, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String entityName;
    private final PojoRawTypeIdentifier<E> typeIdentifier;
    private final PojoCaster<E> caster;
    private final IdentifierMappingImplementor<I, E> identifierMapping;
    private final BeanHolder<? extends RoutingBridge<? super E>> routingBridgeHolder;
    private final PojoIndexingProcessor<E> processor;
    private final MappedIndexManager indexManager;
    private final PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver;

    public PojoIndexedTypeManager(String entityName, PojoRawTypeIdentifier<E> typeIdentifier, PojoCaster<E> caster, IdentifierMappingImplementor<I, E> identifierMapping, BeanHolder<? extends RoutingBridge<? super E>> routingBridgeHolder, PojoIndexingProcessor<E> processor, MappedIndexManager indexManager, PojoImplicitReindexingResolver<E, Set<String>> reindexingResolver) {
        this.entityName = entityName;
        this.typeIdentifier = typeIdentifier;
        this.caster = caster;
        this.identifierMapping = identifierMapping;
        this.routingBridgeHolder = routingBridgeHolder;
        this.processor = processor;
        this.indexManager = indexManager;
        this.reindexingResolver = reindexingResolver;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[entityName = " + this.entityName + ", javaType = " + this.typeIdentifier + "]";
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.push(IdentifierMappingImplementor::close, this.identifierMapping);
            closer.push(RoutingBridge::close, this.routingBridgeHolder, BeanHolder::get);
            closer.push(BeanHolder::close, this.routingBridgeHolder);
            closer.push(PojoIndexingProcessor::close, this.processor);
            closer.push(PojoImplicitReindexingResolver::close, this.reindexingResolver);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("entityName", (Object)this.entityName).attribute("typeIdentifier", this.typeIdentifier).attribute("indexManager", (Object)this.indexManager).attribute("identifierMapping", this.identifierMapping).attribute("routingBridgeHolder", this.routingBridgeHolder).attribute("processor", this.processor).attribute("reindexingResolver", this.reindexingResolver);
    }

    @Override
    public PojoRawTypeIdentifier<E> typeIdentifier() {
        return this.typeIdentifier;
    }

    @Override
    public IdentifierMappingImplementor<I, E> identifierMapping() {
        return this.identifierMapping;
    }

    @Override
    public Supplier<E> toEntitySupplier(PojoWorkSessionContext<?> sessionContext, Object entity) {
        PojoRuntimeIntrospector introspector = sessionContext.runtimeIntrospector();
        return new CachingCastingEntitySupplier<E>(this.caster, introspector, entity);
    }

    @Override
    public String toDocumentIdentifier(PojoWorkSessionContext<?> sessionContext, I identifier) {
        return this.identifierMapping.toDocumentIdentifier(identifier, sessionContext.mappingContext());
    }

    @Override
    public PojoWorkRouter createRouter(PojoWorkSessionContext<?> sessionContext, I identifier, Supplier<E> entitySupplier) {
        if (this.routingBridgeHolder == null) {
            return NoOpDocumentRouter.INSTANCE;
        }
        return new RoutingBridgeDocumentRouter<E>(sessionContext.routingBridgeRouteContext(), (RoutingBridge)this.routingBridgeHolder.get(), identifier, entitySupplier.get());
    }

    @Override
    public PojoDocumentContributor<E> toDocumentContributor(PojoWorkSessionContext<?> sessionContext, I identifier, Supplier<E> entitySupplier) {
        return new PojoDocumentContributor<E>(this.entityName, this.processor, sessionContext, identifier, entitySupplier);
    }

    @Override
    public boolean requiresSelfReindexing(Set<String> dirtyPaths) {
        return this.reindexingResolver.requiresSelfReindexing(dirtyPaths);
    }

    @Override
    public void resolveEntitiesToReindex(PojoReindexingCollector collector, PojoWorkSessionContext<?> sessionContext, Object identifier, Supplier<E> entitySupplier, PojoImplicitReindexingResolverRootContext<Set<String>> context) {
        try {
            this.reindexingResolver.resolveEntitiesToReindex(collector, entitySupplier.get(), context);
        }
        catch (RuntimeException e) {
            Object entityReference = EntityReferenceFactory.safeCreateEntityReference(sessionContext.entityReferenceFactory(), (String)this.entityName, (Object)identifier, e::addSuppressed);
            throw log.errorResolvingEntitiesToReindex(entityReference, e.getMessage(), e);
        }
    }

    @Override
    public IndexSchemaManager schemaManager() {
        return this.indexManager.schemaManager();
    }

    @Override
    public PojoTypeIndexer<I, E> createIndexer(PojoWorkSessionContext<?> sessionContext) {
        return new PojoTypeIndexer(this, sessionContext, this.indexManager.createIndexer(sessionContext));
    }

    @Override
    public IndexWorkspace createWorkspace(DetachedBackendSessionContext sessionContext) {
        return this.indexManager.createWorkspace(sessionContext);
    }

    @Override
    public <R> PojoIndexedTypeIndexingPlan<I, E, R> createIndexingPlan(PojoWorkSessionContext<R> sessionContext, DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return new PojoIndexedTypeIndexingPlan(this, sessionContext, this.indexManager.createIndexingPlan(sessionContext, sessionContext.entityReferenceFactory(), commitStrategy, refreshStrategy));
    }

    @Override
    public <R, E2> MappedIndexScopeBuilder<R, E2> createScopeBuilder(BackendMappingContext mappingContext) {
        return this.indexManager.createScopeBuilder(mappingContext);
    }

    @Override
    public void addTo(MappedIndexScopeBuilder<?, ?> builder) {
        this.indexManager.addTo(builder);
    }
}

