/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.timing.spi;

import java.time.Duration;
import org.hibernate.search.engine.common.timing.Deadline;
import org.hibernate.search.engine.logging.impl.QueryLog;
import org.hibernate.search.util.common.SearchTimeoutException;

public final class StaticDeadline
implements Deadline {
    private final long remainingTimeMillis;

    public static Deadline ofMilliseconds(long milliseconds) {
        return new StaticDeadline(milliseconds);
    }

    private StaticDeadline(long remainingTimeMillis) {
        this.remainingTimeMillis = remainingTimeMillis;
    }

    @Override
    public long checkRemainingTimeMillis() {
        return this.remainingTimeMillis;
    }

    @Override
    public void forceTimeout(Exception cause) {
        throw this.forceTimeoutAndCreateException(cause);
    }

    @Override
    public SearchTimeoutException forceTimeoutAndCreateException(Exception cause) {
        return QueryLog.INSTANCE.timedOut(Duration.ofMillis(this.remainingTimeMillis), cause);
    }
}

