/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import javax.transaction.Synchronization;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.WeakIdentityHashMap;
import org.slf4j.Logger;

public class PostTransactionWorkQueueSynchronization
implements Synchronization {
    private static final Logger log = LoggerFactory.make();
    private final QueueingProcessor queueingProcessor;
    private boolean consumed;
    private boolean prepared;
    private final WeakIdentityHashMap queuePerTransaction;
    private final WorkQueue queue;

    public PostTransactionWorkQueueSynchronization(QueueingProcessor queueingProcessor, WeakIdentityHashMap queuePerTransaction, SearchFactoryImplementor searchFactoryImplementor) {
        this.queueingProcessor = queueingProcessor;
        this.queuePerTransaction = queuePerTransaction;
        this.queue = new WorkQueue(searchFactoryImplementor);
    }

    public void add(Work work) {
        this.queueingProcessor.add(work, this.queue);
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void beforeCompletion() {
        if (this.prepared) {
            if (log.isTraceEnabled()) {
                log.trace("Transaction's beforeCompletion() phase already been processed, ignoring: {}", (Object)this.toString());
            }
        } else {
            if (log.isTraceEnabled()) {
                log.trace("Processing Transaction's beforeCompletion() phase: {}", (Object)this.toString());
            }
            this.queueingProcessor.prepareWorks(this.queue);
            this.prepared = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(int i) {
        try {
            if (3 == i) {
                if (log.isTraceEnabled()) {
                    log.trace("Processing Transaction's afterCompletion() phase for {}. Performing work.", (Object)this.toString());
                }
                this.queueingProcessor.performWorks(this.queue);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("Processing Transaction's afterCompletion() phase for {}. Cancelling work due to transaction status {}", (Object)this.toString(), (Object)i);
                }
                this.queueingProcessor.cancelWorks(this.queue);
            }
        }
        finally {
            this.consumed = true;
            if (this.queuePerTransaction != null) {
                this.queuePerTransaction.removeValue(this);
            }
        }
    }

    public void flushWorks() {
        WorkQueue subQueue = this.queue.splitQueue();
        this.queueingProcessor.prepareWorks(subQueue);
        this.queueingProcessor.performWorks(subQueue);
    }
}

