/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.analyzer.spi.ScopedAnalyzer;

public final class ScopedLuceneAnalyzer
extends AnalyzerWrapper
implements ScopedAnalyzer {
    private final Analyzer globalAnalyzer;
    private final Map<String, Analyzer> scopedAnalyzers;

    public ScopedLuceneAnalyzer(Analyzer globalAnalyzer) {
        this(globalAnalyzer, Collections.emptyMap());
    }

    public ScopedLuceneAnalyzer(Analyzer globalAnalyzer, Map<String, Analyzer> scopedAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzer = globalAnalyzer;
        this.scopedAnalyzers = Collections.unmodifiableMap(new HashMap<String, Analyzer>(scopedAnalyzers));
    }

    Analyzer getGlobalAnalyzer() {
        return this.globalAnalyzer;
    }

    Map<String, Analyzer> getScopedAnalyzers() {
        return this.scopedAnalyzers;
    }

    public boolean isCompositeOfSameInstances(ScopedLuceneAnalyzer other) {
        if (this.globalAnalyzer != other.globalAnalyzer) {
            return false;
        }
        if (this.scopedAnalyzers.size() != other.scopedAnalyzers.size()) {
            return false;
        }
        for (String fieldname : this.scopedAnalyzers.keySet()) {
            if (this.scopedAnalyzers.get(fieldname) == other.scopedAnalyzers.get(fieldname)) continue;
            return false;
        }
        return true;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            analyzer = this.globalAnalyzer;
        }
        return analyzer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.globalAnalyzer);
        sb.append(",");
        sb.append(this.scopedAnalyzers);
        sb.append(">");
        return sb.toString();
    }
}

