/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.ClassWriter;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.Version;
import org.hibernate.jpamodelgen.annotation.AnnotationEmbeddable;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.model.MetaEntity;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;
import org.hibernate.jpamodelgen.xml.XmlParser;

@SupportedAnnotationTypes(value={"javax.persistence.Entity", "javax.persistence.MappedSuperclass", "javax.persistence.Embeddable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"debug", "persistenceXml", "ormXmlList", "fullyAnnotationConfigured", "lazyXmlParsing", "addGeneratedAnnotation"})
public class JPAMetaModelEntityProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    public static final String PERSISTENCE_XML_OPTION = "persistenceXml";
    public static final String ORM_XML_OPTION = "ormXmlList";
    public static final String FULLY_ANNOTATION_CONFIGURED_OPTION = "fullyAnnotationConfigured";
    public static final String LAZY_XML_PARSING = "lazyXmlParsing";
    public static final String ADD_GENERATED_ANNOTATION = "addGeneratedAnnotation";
    private static final Boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = Boolean.FALSE;
    private Context context;

    @Override
    public void init(ProcessingEnvironment env) {
        super.init(env);
        this.context = new Context(env);
        this.context.logMessage(Diagnostic.Kind.NOTE, "Hibernate JPA 2 Static-Metamodel Generator " + Version.getVersionString());
        String tmp = env.getOptions().get(ADD_GENERATED_ANNOTATION);
        boolean addGeneratedAnnotation = Boolean.parseBoolean(tmp);
        this.context.setAddGeneratedAnnotation(addGeneratedAnnotation);
        tmp = env.getOptions().get(FULLY_ANNOTATION_CONFIGURED_OPTION);
        boolean fullyAnnotationConfigured = Boolean.parseBoolean(tmp);
        if (!fullyAnnotationConfigured) {
            XmlParser parser = new XmlParser(this.context);
            parser.parseXml();
            if (this.context.isPersistenceUnitCompletelyXmlConfigured()) {
                this.createMetaModelClasses();
            }
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.processingOver() || annotations.size() == 0) {
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        if (this.context.isPersistenceUnitCompletelyXmlConfigured()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Skipping the processing of annotations since persistence unit is purely xml configured.");
            return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
        }
        Set<? extends Element> elements = roundEnvironment.getRootElements();
        for (Element element : elements) {
            if (!this.isJPAEntity(element)) continue;
            this.context.logMessage(Diagnostic.Kind.OTHER, "Processing annotated class " + element.toString());
            this.handleRootElementAnnotationMirrors(element);
        }
        this.createMetaModelClasses();
        return ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS;
    }

    private void createMetaModelClasses() {
        ArrayList<String> generatedModelClasses = new ArrayList<String>();
        for (MetaEntity entity : this.context.getMetaEntities()) {
            this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for entity " + entity);
            ClassWriter.writeFile(entity, this.context);
            generatedModelClasses.add(entity.getQualifiedName());
        }
        Collection<MetaEntity> toProcessEntities = this.context.getMetaEmbeddables();
        while (!toProcessEntities.isEmpty()) {
            HashSet<MetaEntity> processedEntities = new HashSet<MetaEntity>();
            int toProcessCountBeforeLoop = toProcessEntities.size();
            for (MetaEntity entity : toProcessEntities) {
                if (generatedModelClasses.contains(entity.getQualifiedName())) {
                    toProcessEntities.remove(entity);
                    continue;
                }
                if (this.modelGenerationNeedsToBeDeferred(toProcessEntities, entity)) continue;
                this.context.logMessage(Diagnostic.Kind.OTHER, "Writing meta model for embeddable/mapped superclass" + entity);
                ClassWriter.writeFile(entity, this.context);
                processedEntities.add(entity);
            }
            toProcessEntities.removeAll(processedEntities);
            if (toProcessEntities.size() < toProcessCountBeforeLoop) continue;
            this.context.logMessage(Diagnostic.Kind.ERROR, "Potential endless loop in generation of entities.");
        }
    }

    private boolean modelGenerationNeedsToBeDeferred(Collection<MetaEntity> entities, MetaEntity containedEntity) {
        ContainsAttributeTypeVisitor visitor = new ContainsAttributeTypeVisitor(containedEntity.getTypeElement(), this.context);
        for (MetaEntity entity : entities) {
            boolean contains;
            TypeMirror mirror;
            if (entity.equals(containedEntity)) continue;
            for (VariableElement variableElement : ElementFilter.fieldsIn(entity.getTypeElement().getEnclosedElements())) {
                mirror = variableElement.asType();
                if (!TypeKind.DECLARED.equals((Object)mirror.getKind()) || !(contains = mirror.accept(visitor, variableElement).booleanValue())) continue;
                return true;
            }
            for (ExecutableElement executableElement : ElementFilter.methodsIn(entity.getTypeElement().getEnclosedElements())) {
                mirror = executableElement.asType();
                if (!TypeKind.DECLARED.equals((Object)mirror.getKind()) || !(contains = mirror.accept(visitor, executableElement).booleanValue())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isJPAEntity(Element element) {
        return TypeUtils.containsAnnotation(element, Entity.class, MappedSuperclass.class, Embeddable.class);
    }

    private void handleRootElementAnnotationMirrors(Element element) {
        List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            if (!ElementKind.CLASS.equals((Object)element.getKind())) continue;
            String fqn = ((TypeElement)element).getQualifiedName().toString();
            MetaEntity alreadyExistingMetaEntity = this.tryGettingExistingEntityFromContext(annotationMirror, fqn);
            if (alreadyExistingMetaEntity != null && alreadyExistingMetaEntity.isMetaComplete()) {
                String msg = "Skipping processing of annotations for " + fqn + " since xml configuration is metadata complete.";
                this.context.logMessage(Diagnostic.Kind.OTHER, msg);
                continue;
            }
            AnnotationMetaEntity metaEntity = TypeUtils.containsAnnotation(element, Embeddable.class) ? new AnnotationEmbeddable((TypeElement)element, this.context) : new AnnotationMetaEntity((TypeElement)element, this.context);
            if (alreadyExistingMetaEntity != null) {
                metaEntity.mergeInMembers(alreadyExistingMetaEntity.getMembers());
            }
            this.addMetaEntityToContext(annotationMirror, metaEntity);
        }
    }

    private MetaEntity tryGettingExistingEntityFromContext(AnnotationMirror mirror, String fqn) {
        MetaEntity alreadyExistingMetaEntity = null;
        if (TypeUtils.isAnnotationMirrorOfType(mirror, Entity.class)) {
            alreadyExistingMetaEntity = this.context.getMetaEntity(fqn);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, MappedSuperclass.class) || TypeUtils.isAnnotationMirrorOfType(mirror, Embeddable.class)) {
            alreadyExistingMetaEntity = this.context.getMetaEmbeddable(fqn);
        }
        return alreadyExistingMetaEntity;
    }

    private void addMetaEntityToContext(AnnotationMirror mirror, AnnotationMetaEntity metaEntity) {
        if (TypeUtils.isAnnotationMirrorOfType(mirror, Entity.class)) {
            this.context.addMetaEntity(metaEntity.getQualifiedName(), metaEntity);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, MappedSuperclass.class)) {
            this.context.addMetaEntity(metaEntity.getQualifiedName(), metaEntity);
        } else if (TypeUtils.isAnnotationMirrorOfType(mirror, Embeddable.class)) {
            this.context.addMetaEmbeddable(metaEntity.getQualifiedName(), metaEntity);
        }
    }

    class ContainsAttributeTypeVisitor
    extends SimpleTypeVisitor6<Boolean, Element> {
        private Context context;
        private TypeElement type;

        ContainsAttributeTypeVisitor(TypeElement elem, Context context) {
            this.context = context;
            this.type = elem;
        }

        @Override
        public Boolean visitDeclared(DeclaredType declaredType, Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            String fqNameOfReturnType = returnedElement.getQualifiedName().toString();
            String collection = Constants.COLLECTIONS.get(fqNameOfReturnType);
            if (collection != null) {
                TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, fqNameOfReturnType, null, this.context);
                returnedElement = (TypeElement)this.context.getTypeUtils().asElement(collectionElementType);
            }
            if (this.type.getQualifiedName().toString().equals(returnedElement.getQualifiedName().toString())) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitExecutable(ExecutableType t, Element element) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) {
                return Boolean.FALSE;
            }
            String string = element.getSimpleName().toString();
            if (!StringUtil.isPropertyName(string)) {
                return Boolean.FALSE;
            }
            TypeMirror returnType = t.getReturnType();
            return returnType.accept(this, element);
        }
    }
}

