/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.objectfile.debugentry;

import com.oracle.objectfile.debugentry.ClassEntry;
import com.oracle.objectfile.debugentry.FileEntry;
import com.oracle.objectfile.debugentry.Range;
import com.oracle.objectfile.debuginfo.DebugInfoProvider;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class PrimaryEntry {
    private Range primary;
    private ClassEntry classEntry;
    private List<Range> subranges;
    private HashMap<Range, FileEntry> subrangeIndex;
    private List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos;
    private int frameSize;

    public PrimaryEntry(Range primary, List<DebugInfoProvider.DebugFrameSizeChange> frameSizeInfos, int frameSize, ClassEntry classEntry) {
        this.primary = primary;
        this.classEntry = classEntry;
        this.subranges = new LinkedList<Range>();
        this.subrangeIndex = new HashMap();
        this.frameSizeInfos = frameSizeInfos;
        this.frameSize = frameSize;
    }

    public void addSubRange(Range subrange, FileEntry subFileEntry) {
        assert (!this.subranges.contains(subrange));
        assert (this.subrangeIndex.get(subrange) == null);
        this.subranges.add(subrange);
        this.subrangeIndex.put(subrange, subFileEntry);
    }

    public Range getPrimary() {
        return this.primary;
    }

    public ClassEntry getClassEntry() {
        return this.classEntry;
    }

    public List<Range> getSubranges() {
        return this.subranges;
    }

    public FileEntry getSubrangeFileEntry(Range subrange) {
        return this.subrangeIndex.get(subrange);
    }

    public List<DebugInfoProvider.DebugFrameSizeChange> getFrameSizeInfos() {
        return this.frameSizeInfos;
    }

    public int getFrameSize() {
        return this.frameSize;
    }
}

