/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.graalvm.buildtools.agent.AgentConfiguration;
import org.graalvm.buildtools.agent.AgentMode;
import org.graalvm.buildtools.agent.ConditionalAgentMode;
import org.graalvm.buildtools.agent.DirectAgentMode;
import org.graalvm.buildtools.agent.DisabledAgentMode;
import org.graalvm.buildtools.agent.StandardAgentMode;
import org.graalvm.buildtools.utils.Utils;
import org.graalvm.buildtools.utils.Xpp3DomParser;

public abstract class AgentUtils {
    public static AgentMode getAgentMode(Xpp3Dom agent) throws Exception {
        StandardAgentMode agentMode;
        Xpp3Dom defaultModeNode = Xpp3DomParser.getTagByName(agent, "defaultMode");
        if (defaultModeNode == null) {
            return new StandardAgentMode();
        }
        Xpp3Dom agentModes = Xpp3DomParser.getTagByName(agent, "modes");
        String mode = defaultModeNode.getValue();
        switch (mode.toLowerCase()) {
            case "standard": {
                agentMode = new StandardAgentMode();
                break;
            }
            case "disabled": {
                agentMode = new DisabledAgentMode();
                break;
            }
            case "conditional": {
                if (agentModes == null) {
                    throw new RuntimeException("Tag <modes> not provided in agent configuration.");
                }
                Xpp3Dom userCodeFilterPathNode = Xpp3DomParser.getTagByName(agentModes, "userCodeFilterPath");
                Xpp3Dom extraFilterPathNode = Xpp3DomParser.getTagByName(agentModes, "extraFilterPath");
                if (userCodeFilterPathNode == null) {
                    throw new Exception("UserCodeFilterPath must be provided in agent configuration");
                }
                Boolean parallel = AgentUtils.parseBooleanNode(agentModes, "parallel");
                agentMode = new ConditionalAgentMode(userCodeFilterPathNode.getValue(), extraFilterPathNode != null ? extraFilterPathNode.getValue() : "", parallel == null ? false : parallel);
                break;
            }
            case "direct": {
                if (agentModes == null) {
                    throw new RuntimeException("Tag <modes> not provided in agent configuration.");
                }
                Xpp3Dom directModeNode = Xpp3DomParser.getTagByName(agentModes, "direct");
                if (directModeNode == null) {
                    throw new RuntimeException("Direct agent mode not provided in configuration.");
                }
                List options = Arrays.stream(directModeNode.getValue().split(" ")).collect(Collectors.toList());
                agentMode = new DirectAgentMode(options);
                break;
            }
            default: {
                throw new Exception("Unknown agent mode selected: " + mode);
            }
        }
        return agentMode;
    }

    public static AgentConfiguration collectAgentProperties(MavenSession session, Xpp3Dom rootNode) throws RuntimeException {
        AgentMode mode;
        Xpp3Dom agent = Xpp3DomParser.getTagByName(rootNode, "agent");
        if (agent == null) {
            Boolean agentEnabledInCmd = AgentUtils.isAgentEnabledInCmd(session);
            if (agentEnabledInCmd != null && agentEnabledInCmd.booleanValue()) {
                return new AgentConfiguration(new AgentMode[]{new StandardAgentMode()});
            }
            return new AgentConfiguration(new AgentMode[0]);
        }
        if (!AgentUtils.isAgentEnabled(session, agent)) {
            return new AgentConfiguration(new AgentMode[0]);
        }
        Xpp3Dom options = Xpp3DomParser.getTagByName(agent, "options");
        ArrayList callerFilterFiles = (ArrayList)AgentUtils.getFilterFiles(options, "callerFilterFiles");
        ArrayList accessFilterFiles = (ArrayList)AgentUtils.getFilterFiles(options, "accessFilterFiles");
        Boolean builtinCallerFilter = AgentUtils.parseBooleanNode(options, "builtinCallerFilter");
        Boolean builtinHeuristicFilter = AgentUtils.parseBooleanNode(options, "builtinHeuristicFilter");
        Boolean enableExperimentalPredefinedClasses = AgentUtils.parseBooleanNode(options, "enableExperimentalPredefinedClasses");
        Boolean enableExperimentalUnsafeAllocationTracing = AgentUtils.parseBooleanNode(options, "enableExperimentalUnsafeAllocationTracing");
        Boolean trackReflectionMetadata = AgentUtils.parseBooleanNode(options, "trackReflectionMetadata");
        try {
            mode = AgentUtils.getAgentMode(agent);
        }
        catch (Exception e) {
            throw new RuntimeException("Agent mode configuration error. Reason: " + e.getMessage());
        }
        return new AgentConfiguration((Collection)callerFilterFiles, (Collection)accessFilterFiles, builtinCallerFilter, builtinHeuristicFilter, enableExperimentalPredefinedClasses, enableExperimentalUnsafeAllocationTracing, trackReflectionMetadata, mode);
    }

    public static List<String> getDisabledStages(Xpp3Dom rootNode) {
        Xpp3Dom disabledStagesNode;
        ArrayList<String> disabledStages = new ArrayList<String>();
        Xpp3Dom agent = Xpp3DomParser.getTagByName(rootNode, "agent");
        if (agent != null && (disabledStagesNode = Xpp3DomParser.getTagByName(agent, "disabledStages")) != null) {
            Xpp3DomParser.getAllTagsByName(disabledStagesNode, "stage").forEach(stageNode -> disabledStages.add(stageNode.getValue()));
        }
        return disabledStages;
    }

    private static Boolean isAgentEnabledInCmd(MavenSession session) {
        String systemProperty = session.getSystemProperties().getProperty("agent");
        if (systemProperty != null) {
            return Utils.parseBoolean("agent system property", systemProperty);
        }
        return null;
    }

    private static boolean isAgentEnabled(MavenSession session, Xpp3Dom agent) {
        Boolean cmdEnable = AgentUtils.isAgentEnabledInCmd(session);
        if (cmdEnable != null) {
            return cmdEnable;
        }
        Boolean val = AgentUtils.parseBooleanNode(agent, "enabled");
        if (val == null) {
            return false;
        }
        return val;
    }

    private static List<String> getFilterFiles(Xpp3Dom root, String type) {
        if (root == null) {
            return new ArrayList<String>();
        }
        Xpp3Dom filterFileNode = Xpp3DomParser.getTagByName(root, type);
        if (filterFileNode == null) {
            return new ArrayList<String>();
        }
        return Xpp3DomParser.getAllTagsByName(filterFileNode, "filterFile").stream().map(Xpp3Dom::getValue).collect(Collectors.toCollection(ArrayList::new));
    }

    private static Boolean parseBooleanNode(Xpp3Dom root, String name) {
        if (root == null) {
            return null;
        }
        Xpp3Dom node = Xpp3DomParser.getTagByName(root, name);
        if (node == null) {
            return null;
        }
        return Utils.parseBoolean("<" + name + ">", node.getValue());
    }
}

