/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.reachability.internal;

import java.util.Optional;
import org.graalvm.reachability.Query;

public class DefaultArtifactQuery
implements Query.ArtifactQuery {
    private String groupId;
    private String artifactId;
    private String version;
    private boolean useLatestVersion = false;
    private String forcedConfig = null;

    @Override
    public void gav(String gavCoordinates) {
        String[] gav = gavCoordinates.split(":");
        if (gav.length != 3) {
            throw new IllegalArgumentException("Invalid GAV coordinates: " + gavCoordinates + " (expected format: groupId:artifactId:version)");
        }
        this.groupId = gav[0];
        this.artifactId = gav[1];
        this.version = gav[2];
    }

    @Override
    public void useLatestConfigWhenVersionIsUntested() {
        this.useLatestVersion = true;
        this.forcedConfig = null;
    }

    @Override
    public void doNotUseLatestConfigWhenVersionIsUntested() {
        this.useLatestVersion = false;
    }

    @Override
    public void forceConfigVersion(String version) {
        this.useLatestVersion = false;
        this.forcedConfig = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isUseLatestVersion() {
        return this.useLatestVersion;
    }

    public Optional<String> getForcedConfig() {
        return Optional.ofNullable(this.forcedConfig);
    }
}

