/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.WriteHandler;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpPacket;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.filecache.FileCache;

public class FileCacheFilter
extends BaseFilter {
    private final FileCache fileCache;

    public FileCacheFilter(FileCache fileCache) {
        this.fileCache = fileCache;
    }

    public NextAction handleRead(final FilterChainContext ctx) throws IOException {
        HttpPacket response;
        HttpContent requestContent = (HttpContent)ctx.getMessage();
        HttpRequestPacket request = (HttpRequestPacket)requestContent.getHttpHeader();
        if (this.fileCache.isEnabled() && Method.GET.equals(request.getMethod()) && (response = this.fileCache.get(request)) != null) {
            ctx.write((Object)response);
            HttpContext httpContext = HttpContext.get((FilterChainContext)ctx);
            assert (httpContext != null);
            OutputSink output = httpContext.getOutputSink();
            if (output.canWrite()) {
                return ctx.getStopAction();
            }
            NextAction suspendAction = ctx.getSuspendAction();
            ctx.suspend();
            output.notifyCanWrite(new WriteHandler(){

                public void onWritePossible() throws Exception {
                    this.finish();
                }

                public void onError(Throwable t) {
                    this.finish();
                }

                private void finish() {
                    ctx.completeAndRecycle();
                }
            });
            return suspendAction;
        }
        return ctx.getInvokeAction();
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }
}

