/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;

class ByteBufUtils {
    ByteBufUtils() {
    }

    static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer((byte[])slice.bytes, (int)slice.offset, (int)slice.length));
            }
            if (buffers.size() == 1) {
                return (ByteBuf)buffers.get(0);
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer((int)buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    static BytesReference toBytesReference(ByteBuf buffer) {
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return BytesArray.EMPTY;
        }
        ByteBuffer[] byteBuffers = buffer.nioBuffers();
        return BytesReference.fromByteBuffers((ByteBuffer[])byteBuffers);
    }
}

