/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;

public class CacheKey
extends ConcurrencyManager
implements Cloneable {
    protected Object key;
    protected Object object;
    protected IdentityMap mapOwner;
    protected Object writeLockValue;
    protected Object wrapper;
    protected Record record;
    protected long lastUpdatedQueryId;
    protected int invalidationState = 0;
    public static final int CHECK_INVALIDATION_POLICY = 0;
    public static final int CACHE_KEY_INVALID = -1;
    public static final int MAX_WAIT_TRIES = 10000;
    protected long readTime = 0L;
    protected boolean isWrapper = false;
    protected AbstractRecord protectedForeignKeys;
    protected boolean isIsolated;
    protected Object transactionId;

    protected CacheKey() {
    }

    public CacheKey(Object primaryKey) {
        this.key = primaryKey;
    }

    public CacheKey(Object primaryKey, Object object, Object lockValue) {
        this.key = primaryKey;
        this.writeLockValue = lockValue;
        if (object != null) {
            this.setObject(object);
        }
    }

    public CacheKey(Object primaryKey, Object object, Object lockValue, long readTime, boolean isIsolated) {
        this.key = primaryKey;
        this.writeLockValue = lockValue;
        if (object != null) {
            this.setObject(object);
        }
        this.readTime = readTime;
        this.isIsolated = isIsolated;
    }

    @Override
    public void acquire() {
        if (this.isIsolated) {
            ++this.depth;
            return;
        }
        super.acquire(false);
    }

    @Override
    public void acquire(boolean forMerge) {
        if (this.isIsolated) {
            ++this.depth;
            return;
        }
        super.acquire(forMerge);
    }

    @Override
    public boolean acquireNoWait() {
        if (this.isIsolated) {
            ++this.depth;
            return true;
        }
        return super.acquireNoWait(false);
    }

    public boolean acquireIfUnownedNoWait() {
        if (this.isIsolated) {
            if (this.depth > 0) {
                return false;
            }
            ++this.depth;
            return true;
        }
        return super.acquireIfUnownedNoWait(false);
    }

    @Override
    public boolean acquireNoWait(boolean forMerge) {
        if (this.isIsolated) {
            ++this.depth;
            return true;
        }
        return super.acquireNoWait(forMerge);
    }

    @Override
    public boolean acquireWithWait(boolean forMerge, int wait) {
        if (this.isIsolated) {
            ++this.depth;
            return true;
        }
        return super.acquireWithWait(forMerge, wait);
    }

    @Override
    public void acquireDeferredLock() {
        if (this.isIsolated) {
            ++this.depth;
            return;
        }
        super.acquireDeferredLock();
    }

    @Override
    public void checkReadLock() {
        if (this.isIsolated) {
            return;
        }
        super.checkReadLock();
    }

    @Override
    public void checkDeferredLock() {
        if (this.isIsolated) {
            return;
        }
        super.checkDeferredLock();
    }

    @Override
    public void acquireReadLock() {
        if (this.isIsolated) {
            return;
        }
        super.acquireReadLock();
    }

    @Override
    public boolean acquireReadLockNoWait() {
        if (this.isIsolated) {
            return true;
        }
        return super.acquireReadLockNoWait();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            throw new InternalError(exception.toString());
        }
        return object;
    }

    public boolean equals(Object object) {
        try {
            return this.equals((CacheKey)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean equals(CacheKey key) {
        if (this == key) {
            return true;
        }
        return this.key.equals(key.key);
    }

    public long getLastUpdatedQueryId() {
        return this.lastUpdatedQueryId;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Thread getActiveThread() {
        if (this.isIsolated) {
            if (this.depth > 0) {
                return Thread.currentThread();
            }
            return null;
        }
        return super.getActiveThread();
    }

    public Object getObject() {
        return this.object;
    }

    public IdentityMap getOwningMap() {
        return this.mapOwner;
    }

    public long getReadTime() {
        return this.readTime;
    }

    public Record getRecord() {
        return this.record;
    }

    public Object getWrapper() {
        return this.wrapper;
    }

    public CacheKey getWrappedCacheKey() {
        return this;
    }

    public Object getWriteLockValue() {
        return this.writeLockValue;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean isIsolated() {
        return this.isIsolated;
    }

    public boolean isWrapper() {
        return this.isWrapper;
    }

    public AbstractRecord getProtectedForeignKeys() {
        if (this.protectedForeignKeys == null) {
            this.protectedForeignKeys = new DatabaseRecord();
        }
        return this.protectedForeignKeys;
    }

    public int getInvalidationState() {
        return this.invalidationState;
    }

    @Override
    public void release() {
        if (this.isIsolated) {
            --this.depth;
            return;
        }
        super.release();
    }

    @Override
    public void releaseDeferredLock() {
        if (this.isIsolated) {
            --this.depth;
            return;
        }
        super.releaseDeferredLock();
    }

    @Override
    public void releaseReadLock() {
        if (this.isIsolated) {
            return;
        }
        super.releaseReadLock();
    }

    public Object removeFromOwningMap() {
        if (this.getOwningMap() != null) {
            return this.getOwningMap().remove(this);
        }
        return null;
    }

    public void setInvalidationState(int invalidationState) {
        this.invalidationState = invalidationState;
    }

    public void setLastUpdatedQueryId(long id) {
        this.lastUpdatedQueryId = id;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setOwningMap(IdentityMap map) {
        this.mapOwner = map;
    }

    public void setProtectedForeignKeys(AbstractRecord protectedForeignKeys) {
        this.protectedForeignKeys = protectedForeignKeys;
    }

    public void setReadTime(long readTime) {
        this.readTime = readTime;
        this.invalidationState = 0;
    }

    public void setRecord(Record newRecord) {
        this.record = newRecord;
    }

    public void setWrapper(Object wrapper) {
        this.wrapper = wrapper;
    }

    public void setWriteLockValue(Object writeLockValue) {
        this.writeLockValue = writeLockValue;
    }

    @Override
    public String toString() {
        int hashCode = 0;
        if (this.getObject() != null) {
            hashCode = this.getObject().hashCode();
        }
        return "[" + this.getKey() + ": " + hashCode + ": " + this.getWriteLockValue() + ": " + this.getReadTime() + ": " + this.getObject() + "]";
    }

    public void updateAccess() {
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    public void setIsWrapper(boolean isWrapper) {
        this.isWrapper = isWrapper;
    }

    public Object getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(Object transactionId) {
        this.transactionId = transactionId;
    }

    public synchronized Object waitForObject() {
        try {
            int count = 0;
            while (this.object == null && this.isAcquired()) {
                if (count > 10000) {
                    throw ConcurrencyException.maxTriesLockOnBuildObjectExceded(this.getActiveThread(), Thread.currentThread());
                }
                this.wait(10L);
                ++count;
            }
        }
        catch (InterruptedException interruptedException) {}
        return this.object;
    }
}

