/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.framework;

import java.security.ProtectionDomain;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCollisionHook;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleLoader;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.framework.EquinoxEventPublisher;
import org.eclipse.osgi.internal.framework.OSGiFrameworkHooks;
import org.eclipse.osgi.internal.framework.StorageSaver;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.FragmentLoader;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.Storage;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;

public class EquinoxContainerAdaptor
extends ModuleContainerAdaptor {
    private static final ClassLoader BOOT_CLASSLOADER = new ClassLoader(Object.class.getClassLoader()){};
    private final EquinoxContainer container;
    private final Storage storage;
    private final OSGiFrameworkHooks hooks;
    private final Map<Long, BundleInfo.Generation> initial;
    private final ClassLoader moduleClassLoaderParent;
    private final AtomicLong lastSecurityAdminFlush;

    public EquinoxContainerAdaptor(EquinoxContainer container, Storage storage, Map<Long, BundleInfo.Generation> initial) {
        this.container = container;
        this.storage = storage;
        this.hooks = new OSGiFrameworkHooks(container, storage);
        this.initial = initial;
        this.moduleClassLoaderParent = EquinoxContainerAdaptor.getModuleClassLoaderParent(container.getConfiguration());
        this.lastSecurityAdminFlush = new AtomicLong();
    }

    private static ClassLoader getModuleClassLoaderParent(EquinoxConfiguration configuration) {
        ClassLoader appCL;
        for (ClassLoaderHook hook : configuration.getHookRegistry().getClassLoaderHooks()) {
            ClassLoader parent = hook.getModuleClassLoaderParent(configuration);
            if (parent == null) continue;
            return parent;
        }
        String type = configuration.getConfiguration("org.osgi.framework.bundle.parent");
        if (type == null) {
            type = configuration.getConfiguration("osgi.parentClassloader", "boot");
        }
        if ("framework".equalsIgnoreCase(type) || "fwk".equalsIgnoreCase(type)) {
            ClassLoader cl = EquinoxContainer.class.getClassLoader();
            return cl == null ? BOOT_CLASSLOADER : cl;
        }
        if ("app".equalsIgnoreCase(type)) {
            return ClassLoader.getSystemClassLoader();
        }
        if ("ext".equalsIgnoreCase(type) && (appCL = ClassLoader.getSystemClassLoader()) != null) {
            return appCL.getParent();
        }
        return BOOT_CLASSLOADER;
    }

    @Override
    public ModuleCollisionHook getModuleCollisionHook() {
        return this.hooks.getModuleCollisionHook();
    }

    @Override
    public ResolverHookFactory getResolverHookFactory() {
        return this.hooks.getResolverHookFactory();
    }

    @Override
    public void publishContainerEvent(ModuleContainerAdaptor.ContainerEvent type, Module module, Throwable error, FrameworkListener ... listeners) {
        EquinoxEventPublisher publisher = this.container.getEventPublisher();
        if (publisher != null) {
            publisher.publishFrameworkEvent(EquinoxContainerAdaptor.getType(type), module.getBundle(), error, listeners);
        }
    }

    @Override
    public void publishModuleEvent(ModuleContainerAdaptor.ModuleEvent type, Module module, Module origin) {
        EquinoxEventPublisher publisher = this.container.getEventPublisher();
        if (publisher != null) {
            publisher.publishBundleEvent(this.getType(type), module.getBundle(), origin.getBundle());
        }
    }

    @Override
    public Module createModule(String location, long id, EnumSet<Module.Settings> settings, int startlevel) {
        EquinoxBundle bundle = new EquinoxBundle(id, location, this.storage.getModuleContainer(), settings, startlevel, this.container);
        return bundle.getModule();
    }

    @Override
    public SystemModule createSystemModule() {
        return (SystemModule)new EquinoxBundle.SystemBundle(this.storage.getModuleContainer(), this.container).getModule();
    }

    @Override
    public String getProperty(String key) {
        return this.storage.getConfiguration().getConfiguration(key);
    }

    @Override
    public ModuleLoader createModuleLoader(ModuleWiring wiring) {
        if (wiring.getBundle().getBundleId() == 0L) {
            ClassLoader cl = EquinoxContainer.class.getClassLoader();
            cl = cl == null ? BOOT_CLASSLOADER : cl;
            return new SystemBundleLoader(wiring, this.container, cl);
        }
        if ((wiring.getRevision().getTypes() & 1) != 0) {
            return new FragmentLoader();
        }
        return new BundleLoader(wiring, this.container, this.moduleClassLoaderParent);
    }

    @Override
    public BundleInfo.Generation getRevisionInfo(String location, long id) {
        return this.initial.remove(id);
    }

    @Override
    public void associateRevision(ModuleRevision revision, Object revisionInfo) {
        ((BundleInfo.Generation)revisionInfo).setRevision(revision);
    }

    @Override
    public void invalidateWiring(ModuleWiring moduleWiring, ModuleLoader current) {
        if (current instanceof BundleLoader) {
            BundleLoader bundleLoader = (BundleLoader)current;
            bundleLoader.close();
            long updatedTimestamp = this.storage.getModuleDatabase().getRevisionsTimestamp();
            if (System.getSecurityManager() != null && updatedTimestamp != this.lastSecurityAdminFlush.getAndSet(updatedTimestamp)) {
                this.storage.getSecurityAdmin().clearCaches();
                List<Module> modules = this.storage.getModuleContainer().getModules();
                for (Module module : modules) {
                    for (ModuleRevision revision : module.getRevisions().getModuleRevisions()) {
                        ProtectionDomain domain;
                        BundleInfo.Generation generation = (BundleInfo.Generation)revision.getRevisionInfo();
                        if (generation == null || (domain = generation.getDomain()) == null) continue;
                        ((BundlePermissions)domain.getPermissions()).clearPermissionCache();
                    }
                }
            }
        }
        this.clearManifestCache(moduleWiring);
    }

    private void clearManifestCache(ModuleWiring moduleWiring) {
        boolean frameworkActive = Module.ACTIVE_SET.contains((Object)this.storage.getModuleContainer().getModule(0L).getState());
        ModuleRevision revision = moduleWiring.getRevision();
        Module module = revision.getRevisions().getModule();
        boolean isUninstallingOrUninstalled = Module.State.UNINSTALLED.equals((Object)module.getState()) ^ module.holdsTransitionEventLock(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
        if (!frameworkActive || !isUninstallingOrUninstalled) {
            BundleInfo.Generation generation = (BundleInfo.Generation)moduleWiring.getRevision().getRevisionInfo();
            generation.clearManifestCache();
        }
    }

    static int getType(ModuleContainerAdaptor.ContainerEvent type) {
        switch (type) {
            case ERROR: {
                return 2;
            }
            case INFO: {
                return 32;
            }
            case WARNING: {
                return 16;
            }
            case REFRESH: {
                return 4;
            }
            case START_LEVEL: {
                return 8;
            }
            case STARTED: {
                return 1;
            }
            case STOPPED: {
                return 64;
            }
            case STOPPED_REFRESH: {
                return 256;
            }
            case STOPPED_UPDATE: {
                return 128;
            }
            case STOPPED_TIMEOUT: {
                return 512;
            }
        }
        return 2;
    }

    private int getType(ModuleContainerAdaptor.ModuleEvent type) {
        switch (type) {
            case INSTALLED: {
                return 1;
            }
            case LAZY_ACTIVATION: {
                return 512;
            }
            case RESOLVED: {
                return 32;
            }
            case STARTED: {
                return 2;
            }
            case STARTING: {
                return 128;
            }
            case STOPPING: {
                return 256;
            }
            case STOPPED: {
                return 4;
            }
            case UNINSTALLED: {
                return 16;
            }
            case UNRESOLVED: {
                return 64;
            }
            case UPDATED: {
                return 8;
            }
        }
        return 0;
    }

    @Override
    public void refreshedSystemModule() {
        this.storage.getConfiguration().setConfiguration("osgi.forcedRestart", "true");
    }

    public String toString() {
        return this.container.toString();
    }

    @Override
    public void updatedDatabase() {
        StorageSaver saver = this.container.getStorageSaver();
        if (saver == null) {
            return;
        }
        saver.save();
    }

    @Override
    public void initBegin() {
        this.hooks.initBegin();
    }

    @Override
    public void initEnd() {
        this.hooks.initEnd();
    }

    @Override
    public DebugOptions getDebugOptions() {
        return this.container.getConfiguration().getDebugOptions();
    }
}

