/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteIdentityMap<K, V>
implements Map<K, V> {
    private static final Entry[] emptyArray = new Entry[0];
    private volatile Entry<K, V>[] entries;

    public CopyOnWriteIdentityMap() {
        this.entries = CopyOnWriteIdentityMap.empty();
    }

    public CopyOnWriteIdentityMap(CopyOnWriteIdentityMap<? extends K, ? extends V> source) {
        Entry<? extends K, ? extends V>[] toCopy = super.entries();
        this.entries = toCopy;
    }

    @Override
    public synchronized V put(K key, V value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int size = this.entries.length;
        int i = 0;
        while (i < size) {
            if (this.entries[i].key == key) {
                Object v = this.entries[i].value;
                if (v == value) {
                    return v;
                }
                Entry[] newEntries = new Entry[size];
                System.arraycopy(this.entries, 0, newEntries, 0, size);
                newEntries[i] = new Entry<K, V>(key, value);
                this.entries = newEntries;
                return v;
            }
            ++i;
        }
        Entry[] newEntries = new Entry[size + 1];
        if (size > 0) {
            System.arraycopy(this.entries, 0, newEntries, 0, size);
        }
        newEntries[size] = new Entry<K, V>(key, value);
        this.entries = newEntries;
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> source) {
        int sourceSize = source.size();
        if (sourceSize == 0) {
            return;
        }
        if (source instanceof CopyOnWriteIdentityMap) {
            this.putAll(((CopyOnWriteIdentityMap)source).entries());
            return;
        }
        Entry[] toCopy = new Entry[sourceSize];
        Iterator<Map.Entry<K, V>> iter = source.entrySet().iterator();
        int i = 0;
        while (i < sourceSize) {
            Map.Entry<K, V> mapEntry = iter.next();
            toCopy[i] = new Entry<K, V>(mapEntry.getKey(), mapEntry.getValue());
            ++i;
        }
        this.putAll(toCopy);
    }

    public <L extends K> void putAll(L[] keys) {
        int sourceSize = keys.length;
        if (sourceSize == 0) {
            return;
        }
        Entry[] toCopy = new Entry[sourceSize];
        int i = 0;
        while (i < sourceSize) {
            toCopy[i] = new Entry<L, Object>(keys[i], null);
            ++i;
        }
        this.putAll(toCopy);
    }

    private synchronized void putAll(Entry<? extends K, ? extends V>[] toCopy) {
        int sourceSize = toCopy.length;
        int size = this.entries.length;
        Entry[] newEntries = new Entry[size + sourceSize];
        System.arraycopy(this.entries, 0, newEntries, 0, size);
        int n = 0;
        while (n < sourceSize) {
            block4: {
                Entry<? extends K, ? extends V> copy = toCopy[n];
                int i = 0;
                while (i < size) {
                    if (newEntries[i].key == copy.key) {
                        newEntries[i] = copy;
                        break block4;
                    }
                    ++i;
                }
                newEntries[size] = copy;
                ++size;
            }
            ++n;
        }
        if (size == newEntries.length) {
            this.entries = newEntries;
            return;
        }
        Entry[] e = new Entry[size];
        System.arraycopy(newEntries, 0, e, 0, size);
        this.entries = e;
    }

    @Override
    public synchronized V remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int size = this.entries.length;
        int i = 0;
        while (i < size) {
            if (this.entries[i].key == key) {
                int next;
                Object v = this.entries[i].value;
                if (size == 1) {
                    this.entries = CopyOnWriteIdentityMap.empty();
                    return v;
                }
                Entry[] newEntries = new Entry[size - 1];
                if (i > 0) {
                    System.arraycopy(this.entries, 0, newEntries, 0, i);
                }
                if ((next = size - 1 - i) > 0) {
                    System.arraycopy(this.entries, i + 1, newEntries, i, next);
                }
                this.entries = newEntries;
                return v;
            }
            ++i;
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.entries = CopyOnWriteIdentityMap.empty();
    }

    private Entry<K, V>[] entries() {
        return this.entries;
    }

    private static <K, V> Entry<K, V>[] empty() {
        return emptyArray;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.entries().length;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Entry<K, V>[] e = this.entries();
        int i = 0;
        while (i < e.length) {
            if (e[i].key == key) {
                return e[i].value;
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Entry<K, V>[] e = this.entries();
        int i = 0;
        while (i < e.length) {
            if (e[i].key == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Entry<K, V>[] e = this.entries();
        int i = 0;
        while (i < e.length) {
            if (e[i].value == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet<Map.Entry<K, V>>(this.entries(), 1);
    }

    @Override
    public Set<K> keySet() {
        return new EntrySet(this.entries(), 2);
    }

    @Override
    public Collection<V> values() {
        return new EntrySet(this.entries(), 3);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final V value;

        Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return new StringBuffer().append(this.key).append("=").append(this.value).toString();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ System.identityHashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)obj;
            return this.key == e.getKey() && this.value == e.getValue();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntryIterator<E>
    implements Iterator<E> {
        private final Entry<?, ?>[] entries;
        private final int returnType;
        private int cursor = 0;

        EntryIterator(Entry<?, ?>[] entries, int returnType) {
            this.entries = entries;
            this.returnType = returnType;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.entries.length;
        }

        @Override
        public E next() {
            if (this.cursor == this.entries.length) {
                throw new NoSuchElementException();
            }
            switch (this.returnType) {
                case 1: {
                    Entry<?, ?> entry = this.entries[this.cursor++];
                    return (E)entry;
                }
                case 2: {
                    Object key = this.entries[this.cursor++].key;
                    return (E)key;
                }
                case 3: {
                    Object value = this.entries[this.cursor++].value;
                    return (E)value;
                }
            }
            throw new InternalError();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySet<E>
    extends AbstractSet<E> {
        private final Entry<?, ?>[] entries;
        private final int returnType;
        static final int ENTRY = 1;
        static final int KEY = 2;
        static final int VALUE = 3;

        EntrySet(Entry<?, ?>[] entries, int returnType) {
            this.entries = entries;
            this.returnType = returnType;
        }

        @Override
        public Iterator<E> iterator() {
            return new EntryIterator(this.entries, this.returnType);
        }

        @Override
        public int size() {
            return this.entries.length;
        }
    }
}

