/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.InternalPolicy;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public abstract class ColumnViewer
extends StructuredViewer {
    private CellEditor[] cellEditors;
    private ICellModifier cellModifier;
    private String[] columnProperties;
    private ViewerCell cell = new ViewerCell(null, 0, null);
    private ColumnViewerEditor viewerEditor;
    boolean busy;
    boolean logWhenBusy = true;

    boolean isBusy() {
        if (this.busy) {
            if (this.logWhenBusy) {
                String message = "Ignored reentrant call while viewer is busy.";
                if (!InternalPolicy.DEBUG_LOG_REENTRANT_VIEWER_CALLS) {
                    this.logWhenBusy = false;
                    message = String.valueOf(message) + " This is only logged once per viewer instance, but similar calls will still be ignored.";
                }
                Policy.getLog().log((IStatus)new Status(2, "org.eclipse.jface", message, (Throwable)new RuntimeException()));
            }
            return true;
        }
        return false;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        this.viewerEditor = this.createViewerEditor();
        this.hookEditingSupport(control);
    }

    protected void hookEditingSupport(Control control) {
        if (this.viewerEditor != null) {
            control.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (e.count != 2) {
                        ColumnViewer.this.handleMouseDown(e);
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    ColumnViewer.this.handleMouseDown(e);
                }
            });
        }
    }

    protected abstract ColumnViewerEditor createViewerEditor();

    ViewerCell getCell(Point point) {
        ViewerRow row = this.getViewerRow(point);
        if (row != null) {
            return row.getCell(point);
        }
        return null;
    }

    protected ViewerRow getViewerRow(Point point) {
        Item item = this.getItemAt(point);
        if (item != null) {
            return this.getViewerRowFromItem((Widget)item);
        }
        return null;
    }

    protected abstract ViewerRow getViewerRowFromItem(Widget var1);

    protected abstract Widget getColumnViewerOwner(int var1);

    ViewerColumn getViewerColumn(int columnIndex) {
        Widget columnOwner = this.getColumnViewerOwner(columnIndex);
        if (columnOwner == null) {
            return null;
        }
        ViewerColumn viewer = (ViewerColumn)columnOwner.getData(ViewerColumn.COLUMN_VIEWER_KEY);
        if (viewer == null) {
            viewer = this.createViewerColumn(columnOwner, CellLabelProvider.createViewerLabelProvider(this.getLabelProvider()));
            this.setupEditingSupport(columnIndex, viewer);
        }
        if (viewer.getEditingSupport() == null && this.getCellModifier() != null) {
            this.setupEditingSupport(columnIndex, viewer);
        }
        return viewer;
    }

    private void setupEditingSupport(final int columnIndex, ViewerColumn viewer) {
        if (this.getCellModifier() != null) {
            viewer.setEditingSupport(new EditingSupport(this){

                public boolean canEdit(Object element) {
                    return ColumnViewer.this.getCellModifier().canModify(element, (String)ColumnViewer.this.getColumnProperties()[columnIndex]);
                }

                public CellEditor getCellEditor(Object element) {
                    return ColumnViewer.this.getCellEditors()[columnIndex];
                }

                public Object getValue(Object element) {
                    return ColumnViewer.this.getCellModifier().getValue(element, (String)ColumnViewer.this.getColumnProperties()[columnIndex]);
                }

                public void setValue(Object element, Object value) {
                    ColumnViewer.this.getCellModifier().modify(ColumnViewer.this.findItem(element), (String)ColumnViewer.this.getColumnProperties()[columnIndex], value);
                }
            });
        }
    }

    private ViewerColumn createViewerColumn(Widget columnOwner, CellLabelProvider labelProvider) {
        ViewerColumn column = new ViewerColumn(this, columnOwner){};
        column.setLabelProvider(labelProvider, false);
        return column;
    }

    ViewerCell updateCell(ViewerRow rowItem, int column, Object element) {
        this.cell.update(rowItem, column, element);
        return this.cell;
    }

    protected abstract Item getItemAt(Point var1);

    protected Item getItem(int x, int y) {
        return this.getItemAt(this.getControl().toControl(x, y));
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue((labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider || labelProvider instanceof CellLabelProvider ? 1 : 0) != 0);
        this.updateColumnParts(labelProvider);
        super.setLabelProvider(labelProvider);
    }

    private void updateColumnParts(IBaseLabelProvider labelProvider) {
        ViewerColumn column;
        int i = 0;
        while ((column = this.getViewerColumn(i++)) != null) {
            column.setLabelProvider(CellLabelProvider.createViewerLabelProvider(labelProvider), false);
        }
    }

    public void cancelEditing() {
        if (this.viewerEditor != null) {
            this.viewerEditor.cancelEditing();
        }
    }

    protected void applyEditorValue() {
        if (this.viewerEditor != null) {
            this.viewerEditor.applyEditorValue();
        }
    }

    public void editElement(Object element, int column) {
        ViewerCell cell;
        ViewerRow row;
        Widget item;
        if (this.viewerEditor != null && (item = this.findItem(element)) != null && (row = this.getViewerRowFromItem(item)) != null && (cell = row.getCell(column)) != null) {
            this.getControl().setRedraw(false);
            this.setSelection(new StructuredSelection(cell.getElement()));
            this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell));
            this.getControl().setRedraw(true);
        }
    }

    public CellEditor[] getCellEditors() {
        return this.cellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.cellModifier;
    }

    public Object[] getColumnProperties() {
        return this.columnProperties;
    }

    public boolean isCellEditorActive() {
        if (this.viewerEditor != null) {
            return this.viewerEditor.isCellEditorActive();
        }
        return false;
    }

    public void refresh(Object element) {
        if (this.isBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        super.refresh(element);
    }

    public void refresh(Object element, boolean updateLabels) {
        if (this.isBusy()) {
            return;
        }
        if (this.isCellEditorActive()) {
            this.cancelEditing();
        }
        super.refresh(element, updateLabels);
    }

    public void update(Object element, String[] properties) {
        if (this.isBusy()) {
            return;
        }
        super.update(element, properties);
    }

    public void setCellEditors(CellEditor[] editors) {
        this.cellEditors = editors;
    }

    public void setCellModifier(ICellModifier modifier) {
        this.cellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.columnProperties = columnProperties;
    }

    protected abstract int doGetColumnCount();

    public CellLabelProvider getLabelProvider(int columnIndex) {
        ViewerColumn column = this.getViewerColumn(columnIndex);
        if (column != null) {
            return column.getLabelProvider();
        }
        return null;
    }

    private void handleMouseDown(MouseEvent e) {
        ViewerCell cell = this.getCell(new Point(e.x, e.y));
        if (cell != null) {
            this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell, e));
        }
    }

    protected void triggerEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        this.viewerEditor.handleEditorActivationEvent(event);
    }

    public void setColumnViewerEditor(ColumnViewerEditor columnViewerEditor) {
        Assert.isNotNull((Object)this.viewerEditor);
        this.viewerEditor = columnViewerEditor;
    }

    public ColumnViewerEditor getColumnViewerEditor() {
        return this.viewerEditor;
    }

    protected Object[] getRawChildren(Object parent) {
        boolean oldBusy = this.busy;
        this.busy = true;
        try {
            Object[] objectArray = super.getRawChildren(parent);
            return objectArray;
        }
        finally {
            this.busy = oldBusy;
        }
    }
}

