/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketConnection;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.ConnectionState;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.extensions.mux.Muxer;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import org.eclipse.jetty.websocket.common.io.IOState;

public class MuxChannel
implements WebSocketConnection,
LogicalConnection,
IncomingFrames,
SuspendToken {
    private static final Logger LOG = Log.getLogger(MuxChannel.class);
    private final long channelId;
    private final Muxer muxer;
    private final AtomicBoolean inputClosed;
    private final AtomicBoolean outputClosed;
    private final AtomicBoolean suspendToken;
    private IOState ioState;
    private WebSocketPolicy policy;
    private WebSocketSession session;
    private IncomingFrames incoming;
    private String subProtocol;

    public MuxChannel(long channelId, Muxer muxer) {
        this.channelId = channelId;
        this.muxer = muxer;
        this.policy = muxer.getPolicy().clonePolicy();
        this.suspendToken = new AtomicBoolean(false);
        this.ioState = new IOState();
        this.ioState.setState(ConnectionState.CONNECTING);
        this.inputClosed = new AtomicBoolean(false);
        this.outputClosed = new AtomicBoolean(false);
    }

    @Override
    public void close() {
        this.close(1000, null);
    }

    @Override
    public void close(int statusCode, String reason) {
        CloseInfo close = new CloseInfo(statusCode, reason);
        this.outgoingFrame(close.asFrame(), null);
    }

    @Override
    public void disconnect() {
        this.ioState.setState(ConnectionState.CLOSED);
    }

    public long getChannelId() {
        return this.channelId;
    }

    @Override
    public IOState getIOState() {
        return null;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return null;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.muxer.getRemoteAddress();
    }

    public URI getRequestURI() {
        return null;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    public String getSubProtocol() {
        return this.subProtocol;
    }

    public void incomingError(WebSocketException e) {
        this.incoming.incomingError(e);
    }

    public void incomingFrame(Frame frame) {
        this.incoming.incomingFrame(frame);
    }

    public boolean isActive() {
        return this.ioState.isOpen();
    }

    @Override
    public boolean isOpen() {
        return this.isActive() && this.muxer.isOpen();
    }

    @Override
    public boolean isReading() {
        return true;
    }

    public void onClose() {
        this.ioState.setState(ConnectionState.CLOSED);
    }

    public void onOpen() {
        this.ioState.setState(ConnectionState.OPEN);
    }

    private Future<Void> outgoingAsyncFrame(WebSocketFrame frame) {
        FutureWriteCallback future = new FutureWriteCallback();
        this.outgoingFrame(frame, future);
        return future;
    }

    public void outgoingFrame(Frame frame, WriteCallback callback) {
        this.muxer.output(this.channelId, frame, callback);
    }

    public void ping(ByteBuffer buf) throws IOException {
        this.outgoingFrame(WebSocketFrame.ping().setPayload(buf), null);
    }

    public void resume() {
        if (this.suspendToken.getAndSet(false)) {
            // empty if block
        }
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.incoming = incoming;
    }

    @Override
    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    public void setSubProtocol(String subProtocol) {
        this.subProtocol = subProtocol;
    }

    @Override
    public SuspendToken suspend() {
        this.suspendToken.set(true);
        return this;
    }

    public Future<Void> write(byte[] buf, int offset, int len) {
        ByteBuffer bb = ByteBuffer.wrap(buf, offset, len);
        return this.write(bb);
    }

    public Future<Void> write(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("write with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(buffer);
        return this.outgoingAsyncFrame(frame);
    }

    public Future<Void> write(String message) {
        return this.outgoingAsyncFrame(WebSocketFrame.text(message));
    }
}

