/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerWrapper
extends AbstractHandlerContainer {
    protected Handler _handler;

    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public Handler[] getHandlers() {
        if (this._handler == null) {
            return new Handler[0];
        }
        return new Handler[]{this._handler};
    }

    public void setHandler(Handler handler) {
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        Handler old_handler = this._handler;
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)old_handler, (Object)handler, "handler");
        }
        if (handler != null) {
            handler.setServer(this.getServer());
        }
        this._handler = handler;
    }

    @Override
    protected void doStart() throws Exception {
        if (this._handler != null) {
            this._handler.start();
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._handler != null) {
            this._handler.stop();
        }
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this._handler != null && this.isStarted()) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    @Override
    public void setServer(Server server) {
        Server old_server = this.getServer();
        if (server == old_server) {
            return;
        }
        if (this.isStarted()) {
            throw new IllegalStateException("STARTED");
        }
        super.setServer(server);
        Handler h = this.getHandler();
        if (h != null) {
            h.setServer(server);
        }
        if (server != null && server != old_server) {
            server.getContainer().update((Object)this, null, (Object)this._handler, "handler");
        }
    }

    protected Object expandChildren(Object list, Class byClass) {
        return this.expandHandler(this._handler, list, byClass);
    }

    public <H extends Handler> H getNestedHandlerByClass(Class<H> byclass) {
        HandlerWrapper h = this;
        while (h != null) {
            if (byclass.isInstance(h)) {
                return (H)h;
            }
            Handler w = h.getHandler();
            if (!(w instanceof HandlerWrapper)) break;
            h = (HandlerWrapper)w;
        }
        return null;
    }
}

