/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.AsyncConnection;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Timeout;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements AsyncEndPoint,
ConnectedEndPoint {
    public static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.io.nio");
    private final SelectorManager.SelectSet _selectSet;
    private final SelectorManager _manager;
    private SelectionKey _key;
    private final Runnable _handler = new Runnable(){

        @Override
        public void run() {
            SelectChannelEndPoint.this.handle();
        }
    };
    private int _interestOps;
    private volatile AsyncConnection _connection;
    private boolean _dispatched = false;
    private boolean _asyncDispatch = false;
    private volatile boolean _writable = true;
    private boolean _readBlocked;
    private boolean _writeBlocked;
    private boolean _open;
    private volatile long _idleTimestamp;
    private boolean _ishut;

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key, int maxIdleTime) throws IOException {
        super(channel, maxIdleTime);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._dispatched = false;
        this._asyncDispatch = false;
        this._open = true;
        this._key = key;
        this.setCheckForIdle(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey getSelectionKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return this._key;
        }
    }

    public SelectorManager getSelectManager() {
        return this._manager;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    @Override
    public void setConnection(Connection connection) {
        AsyncConnection old = this._connection;
        this._connection = (AsyncConnection)connection;
        if (old != null && old != this._connection) {
            this._manager.endPointUpgraded(this, old);
        }
    }

    public long getIdleTimestamp() {
        return this._idleTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null || !this._key.isValid()) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                this._key.interestOps(0);
                if (!this._dispatched) {
                    this.updateKey();
                }
                return;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
                this._writable = true;
            }
            if (this._dispatched) {
                this._key.interestOps(0);
            } else {
                this.dispatch();
                if (this._dispatched && !this._selectSet.getManager().isDeferringInterestedOps0()) {
                    this._key.interestOps(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void asyncDispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._dispatched) {
                this._asyncDispatch = true;
            } else {
                this.dispatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._dispatched) {
                throw new IllegalStateException("dispatched");
            }
            this._dispatched = true;
            boolean dispatched = this._manager.dispatch(this._handler);
            if (!dispatched) {
                this._dispatched = false;
                LOG.warn("Dispatched Failed! " + this + " to " + (Object)((Object)this._manager), new Object[0]);
                this.updateKey();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._asyncDispatch) {
                this._asyncDispatch = false;
                return false;
            }
            this._dispatched = false;
            this.updateKey();
        }
        return true;
    }

    @Override
    public void cancelTimeout(Timeout.Task task) {
        this.getSelectSet().cancelTimeout(task);
    }

    @Override
    public void scheduleTimeout(Timeout.Task task, long timeoutMs) {
        this.getSelectSet().scheduleTimeout(task, timeoutMs);
    }

    @Override
    public void setCheckForIdle(boolean check) {
        this._idleTimestamp = check ? System.currentTimeMillis() : 0L;
    }

    @Override
    public boolean isCheckForIdle() {
        return this._idleTimestamp != 0L;
    }

    protected void notIdle() {
        if (this._idleTimestamp != 0L) {
            this._idleTimestamp = System.currentTimeMillis();
        }
    }

    public void checkIdleTimestamp(long now) {
        long idleForMs;
        long idleTimestamp = this._idleTimestamp;
        if (idleTimestamp != 0L && this._maxIdleTime > 0 && (idleForMs = now - idleTimestamp) > (long)this._maxIdleTime) {
            this.onIdleExpired(idleForMs);
            this._idleTimestamp = now;
        }
    }

    @Override
    public void onIdleExpired(long idleForMs) {
        this._connection.onIdleExpired(idleForMs);
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        int fill = super.fill(buffer);
        if (fill > 0) {
            this.notIdle();
        }
        return fill;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        if (l == 0 && (header != null && header.hasContent() || buffer != null && buffer.hasContent() || trailer != null && trailer.hasContent())) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                this._writable = false;
                if (!this._dispatched) {
                    this.updateKey();
                }
            }
        } else if (l > 0) {
            this._writable = true;
            this.notIdle();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        if (l == 0 && buffer != null && buffer.hasContent()) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                this._writable = false;
                if (!this._dispatched) {
                    this.updateKey();
                }
            }
        } else if (l > 0) {
            this._writable = true;
            this.notIdle();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean blockReadable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.isInputShutdown()) {
                throw new EofException();
            }
            long now = this._selectSet.getNow();
            long end = now + timeoutMs;
            boolean check = this.isCheckForIdle();
            this.setCheckForIdle(true);
            try {
                this._readBlocked = true;
                do {
                    if (this.isInputShutdown()) return true;
                    if (!this._readBlocked) return true;
                    try {
                        this.updateKey();
                        this.wait(timeoutMs >= 0L ? end - now : 10000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        now = this._selectSet.getNow();
                    }
                } while (!this._readBlocked || timeoutMs <= 0L || now < end);
                boolean bl = false;
                return bl;
            }
            finally {
                this._readBlocked = false;
                this.setCheckForIdle(check);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean blockWritable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.isOutputShutdown()) {
                throw new EofException();
            }
            long now = this._selectSet.getNow();
            long end = now + timeoutMs;
            boolean check = this.isCheckForIdle();
            this.setCheckForIdle(true);
            try {
                this._writeBlocked = true;
                do {
                    if (!this._writeBlocked) return true;
                    if (this.isOutputShutdown()) return true;
                    try {
                        this.updateKey();
                        this.wait(timeoutMs >= 0L ? end - now : 10000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        now = this._selectSet.getNow();
                    }
                } while (!this._writeBlocked || timeoutMs <= 0L || now < end);
                boolean bl = false;
                return bl;
            }
            finally {
                this._writeBlocked = false;
                this.setCheckForIdle(check);
            }
        }
    }

    @Override
    public void scheduleWrite() {
        if (this._writable) {
            LOG.debug("Required scheduleWrite {}", new Object[]{this});
        }
        this._writable = false;
        this.updateKey();
    }

    @Override
    public boolean isWritable() {
        return this._writable;
    }

    @Override
    public boolean hasProgressed() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        boolean changed;
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int current_ops = -1;
            if (this.getChannel().isOpen()) {
                boolean read_interest = this._readBlocked || !this._dispatched && !this._connection.isSuspended();
                boolean write_interest = this._writeBlocked || !this._dispatched && !this._writable;
                this._interestOps = (!this._socket.isInputShutdown() && read_interest ? 1 : 0) | (!this._socket.isOutputShutdown() && write_interest ? 4 : 0);
                try {
                    current_ops = this._key != null && this._key.isValid() ? this._key.interestOps() : -1;
                }
                catch (Exception e) {
                    this._key = null;
                    LOG.ignore((Throwable)e);
                }
            }
            changed = this._interestOps != current_ops;
        }
        if (changed) {
            this._selectSet.addChange(this);
            this._selectSet.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.getChannel().isOpen()) {
                if (this._interestOps > 0) {
                    if (this._key == null || !this._key.isValid()) {
                        SelectableChannel sc = (SelectableChannel)((Object)this.getChannel());
                        if (sc.isRegistered()) {
                            this.updateKey();
                        } else {
                            try {
                                this._key = ((SelectableChannel)((Object)this.getChannel())).register(this._selectSet.getSelector(), this._interestOps, this);
                            }
                            catch (Exception e) {
                                LOG.ignore((Throwable)e);
                                if (this._key != null && this._key.isValid()) {
                                    this._key.cancel();
                                }
                                if (this._open) {
                                    this._selectSet.destroyEndPoint(this);
                                }
                                this._open = false;
                                this._key = null;
                            }
                        }
                    } else {
                        this._key.interestOps(this._interestOps);
                    }
                } else if (this._key != null && this._key.isValid()) {
                    this._key.interestOps(0);
                } else {
                    this._key = null;
                }
            } else {
                if (this._key != null && this._key.isValid()) {
                    this._key.cancel();
                }
                if (this._open) {
                    this._open = false;
                    this._selectSet.destroyEndPoint(this);
                }
                this._key = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void handle() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e) {
            LOG.ignore((Throwable)e);
        }
        finally {
            this.updateKey();
        }
    }

    public String toString() {
        SelectionKey key = this._key;
        String keyString = "";
        if (key != null) {
            if (key.isValid()) {
                if (key.isReadable()) {
                    keyString = keyString + "r";
                }
                if (key.isWritable()) {
                    keyString = keyString + "w";
                }
            } else {
                keyString = keyString + "!";
            }
        } else {
            keyString = keyString + "-";
        }
        return String.format("SCEP@%x{l(%s)<->r(%s),d=%b,open=%b,ishut=%b,oshut=%b,rb=%b,wb=%b,w=%b,i=%d%s}-{%s}", this.hashCode(), this._socket.getRemoteSocketAddress(), this._socket.getLocalSocketAddress(), this._dispatched, this.isOpen(), this.isInputShutdown(), this.isOutputShutdown(), this._readBlocked, this._writeBlocked, this._writable, this._interestOps, keyString, this._connection);
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    @Override
    public void setMaxIdleTime(int timeMs) throws IOException {
        this._maxIdleTime = timeMs;
    }
}

