/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.NIOBuffer;
import org.eclipse.jetty.io.nio.RandomAccessFileBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ChannelEndPoint
implements EndPoint {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    protected final ByteChannel _channel;
    protected final ByteBuffer[] _gather2 = new ByteBuffer[2];
    protected final Socket _socket;
    protected final InetSocketAddress _local;
    protected final InetSocketAddress _remote;
    protected int _maxIdleTime;

    public ChannelEndPoint(ByteChannel channel) throws IOException {
        this._channel = channel;
        Socket socket = this._socket = channel instanceof SocketChannel ? ((SocketChannel)channel).socket() : null;
        if (this._socket != null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
            this._maxIdleTime = this._socket.getSoTimeout();
        } else {
            this._remote = null;
            this._local = null;
        }
    }

    protected ChannelEndPoint(ByteChannel channel, int maxIdleTime) throws IOException {
        this._channel = channel;
        this._maxIdleTime = maxIdleTime;
        Socket socket = this._socket = channel instanceof SocketChannel ? ((SocketChannel)channel).socket() : null;
        if (this._socket != null) {
            this._local = (InetSocketAddress)this._socket.getLocalSocketAddress();
            this._remote = (InetSocketAddress)this._socket.getRemoteSocketAddress();
            this._socket.setSoTimeout(this._maxIdleTime);
        } else {
            this._remote = null;
            this._local = null;
        }
    }

    @Override
    public boolean isBlocking() {
        return !(this._channel instanceof SelectableChannel) || ((SelectableChannel)((Object)this._channel)).isBlocking();
    }

    @Override
    public boolean blockReadable(long millisecs) throws IOException {
        return true;
    }

    @Override
    public boolean blockWritable(long millisecs) throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    @Override
    public void shutdownInput() throws IOException {
        Socket socket;
        if (this._channel.isOpen() && this._channel instanceof SocketChannel && !(socket = ((SocketChannel)this._channel).socket()).isClosed() && !socket.isInputShutdown()) {
            socket.shutdownInput();
        }
    }

    @Override
    public void shutdownOutput() throws IOException {
        Socket socket;
        if (this._channel.isOpen() && this._channel instanceof SocketChannel && !(socket = ((SocketChannel)this._channel).socket()).isClosed() && !socket.isOutputShutdown()) {
            socket.shutdownOutput();
        }
    }

    @Override
    public boolean isOutputShutdown() {
        return this._channel.isOpen() && this._socket != null && this._socket.isOutputShutdown();
    }

    @Override
    public boolean isInputShutdown() {
        return this._channel.isOpen() && this._socket != null && this._socket.isInputShutdown();
    }

    @Override
    public void close() throws IOException {
        this._channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fill(Buffer buffer) throws IOException {
        Buffer buf = buffer.buffer();
        int len = 0;
        if (buf instanceof NIOBuffer) {
            NIOBuffer nbuf = (NIOBuffer)buf;
            ByteBuffer bbuf = nbuf.getByteBuffer();
            try {
                ByteBuffer byteBuffer = bbuf;
                synchronized (byteBuffer) {
                    try {
                        bbuf.position(buffer.putIndex());
                        len = this._channel.read(bbuf);
                    }
                    finally {
                        buffer.setPutIndex(bbuf.position());
                        bbuf.position(0);
                    }
                }
                if (len < 0 && this.isOpen() && !this.isInputShutdown()) {
                    this.shutdownInput();
                }
            }
            catch (IOException x) {
                try {
                    this.close();
                }
                catch (IOException xx) {
                    LOG.ignore((Throwable)xx);
                }
                if (len > 0) {
                    throw x;
                }
                LOG.ignore((Throwable)x);
                len = -1;
            }
        } else {
            throw new IOException("Not Implemented");
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flush(Buffer buffer) throws IOException {
        Buffer buf = buffer.buffer();
        int len = 0;
        if (buf instanceof NIOBuffer) {
            ByteBuffer bbuf;
            NIOBuffer nbuf = (NIOBuffer)buf;
            ByteBuffer byteBuffer = bbuf = nbuf.getByteBuffer();
            synchronized (byteBuffer) {
                try {
                    bbuf.position(buffer.getIndex());
                    bbuf.limit(buffer.putIndex());
                    len = this._channel.write(bbuf);
                }
                finally {
                    if (len > 0) {
                        buffer.skip(len);
                    }
                    bbuf.position(0);
                    bbuf.limit(bbuf.capacity());
                }
            }
        }
        if (buf instanceof RandomAccessFileBuffer) {
            len = ((RandomAccessFileBuffer)buf).writeTo(this._channel, buffer.getIndex(), buffer.length());
            if (len > 0) {
                buffer.skip(len);
            }
        } else if (buffer.array() != null) {
            ByteBuffer b = ByteBuffer.wrap(buffer.array(), buffer.getIndex(), buffer.length());
            len = this._channel.write(b);
            if (len > 0) {
                buffer.skip(len);
            }
        } else {
            throw new IOException("Not Implemented");
        }
        return len;
    }

    @Override
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        Buffer buf1;
        int length = 0;
        Buffer buf0 = header == null ? null : header.buffer();
        Buffer buffer2 = buf1 = buffer == null ? null : buffer.buffer();
        if (this._channel instanceof GatheringByteChannel && header != null && header.length() != 0 && buf0 instanceof NIOBuffer && buffer != null && buffer.length() != 0 && buf1 instanceof NIOBuffer) {
            length = this.gatheringFlush(header, ((NIOBuffer)buf0).getByteBuffer(), buffer, ((NIOBuffer)buf1).getByteBuffer());
        } else {
            if (header != null) {
                if (buffer != null && buffer.length() > 0 && header.space() > buffer.length()) {
                    header.put(buffer);
                    buffer.clear();
                }
                if (trailer != null && trailer.length() > 0 && header.space() > trailer.length()) {
                    header.put(trailer);
                    trailer.clear();
                }
            }
            if (header != null && header.length() > 0) {
                length = this.flush(header);
            }
            if ((header == null || header.length() == 0) && buffer != null && buffer.length() > 0) {
                length += this.flush(buffer);
            }
            if (!(header != null && header.length() != 0 || buffer != null && buffer.length() != 0 || trailer == null || trailer.length() <= 0)) {
                length += this.flush(trailer);
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int gatheringFlush(Buffer header, ByteBuffer bbuf0, Buffer buffer, ByteBuffer bbuf1) throws IOException {
        int length;
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            ByteBuffer byteBuffer = bbuf0;
            synchronized (byteBuffer) {
                ByteBuffer byteBuffer2 = bbuf1;
                synchronized (byteBuffer2) {
                    try {
                        bbuf0.position(header.getIndex());
                        bbuf0.limit(header.putIndex());
                        bbuf1.position(buffer.getIndex());
                        bbuf1.limit(buffer.putIndex());
                        this._gather2[0] = bbuf0;
                        this._gather2[1] = bbuf1;
                        length = (int)((GatheringByteChannel)((Object)this._channel)).write(this._gather2);
                        int hl = header.length();
                        if (length > hl) {
                            header.clear();
                            buffer.skip(length - hl);
                        } else if (length > 0) {
                            header.skip(length);
                        }
                    }
                    finally {
                        if (!header.isImmutable()) {
                            header.setGetIndex(bbuf0.position());
                        }
                        if (!buffer.isImmutable()) {
                            buffer.setGetIndex(bbuf1.position());
                        }
                        bbuf0.position(0);
                        bbuf1.position(0);
                        bbuf0.limit(bbuf0.capacity());
                        bbuf1.limit(bbuf1.capacity());
                    }
                }
            }
        }
        return length;
    }

    public ByteChannel getChannel() {
        return this._channel;
    }

    @Override
    public String getLocalAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getHostAddress();
    }

    @Override
    public String getLocalHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._local == null || this._local.getAddress() == null || this._local.getAddress().isAnyLocalAddress()) {
            return "0.0.0.0";
        }
        return this._local.getAddress().getCanonicalHostName();
    }

    @Override
    public int getLocalPort() {
        if (this._socket == null) {
            return 0;
        }
        if (this._local == null) {
            return -1;
        }
        return this._local.getPort();
    }

    @Override
    public String getRemoteAddr() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getHostAddress();
    }

    @Override
    public String getRemoteHost() {
        if (this._socket == null) {
            return null;
        }
        if (this._remote == null) {
            return null;
        }
        return this._remote.getAddress().getCanonicalHostName();
    }

    @Override
    public int getRemotePort() {
        if (this._socket == null) {
            return 0;
        }
        return this._remote == null ? -1 : this._remote.getPort();
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean isBufferingInput() {
        return false;
    }

    @Override
    public boolean isBufferingOutput() {
        return false;
    }

    @Override
    public boolean isBufferred() {
        return false;
    }

    @Override
    public int getMaxIdleTime() {
        return this._maxIdleTime;
    }

    @Override
    public void setMaxIdleTime(int timeMs) throws IOException {
        if (this._socket != null && timeMs != this._maxIdleTime) {
            this._socket.setSoTimeout(timeMs > 0 ? timeMs : 0);
        }
        this._maxIdleTime = timeMs;
    }
}

