/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.util.resource.Resource;

public class FileConfigurationManager
implements ConfigurationManager {
    private Resource _file;
    private Map<String, String> _map = new HashMap<String, String>();

    public void setFile(String filename) throws MalformedURLException, IOException {
        this._file = Resource.newResource(filename);
    }

    @Override
    public Map<String, String> getProperties() {
        try {
            this.loadProperties();
            return this._map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadProperties() throws FileNotFoundException, IOException {
        if (this._map.isEmpty() && this._file != null) {
            Properties properties = new Properties();
            properties.load(this._file.getInputStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this._map.put(entry.getKey().toString(), String.valueOf(entry.getValue()));
            }
        }
    }
}

