/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.nested;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.AbstractGenerator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.Buffers;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class NestedGenerator
extends AbstractGenerator {
    private static final Logger LOG = Log.getLogger(NestedGenerator.class);
    final HttpServletResponse _response;
    final String _nestedIn;

    public NestedGenerator(Buffers buffers, EndPoint io, HttpServletResponse response, String nestedIn) {
        super(buffers, io);
        this._response = response;
        this._nestedIn = nestedIn;
    }

    public void addContent(Buffer content, boolean last) throws IOException {
        if (this._noContent) {
            content.clear();
            return;
        }
        if (content.isImmutable()) {
            throw new IllegalArgumentException("immutable");
        }
        if (this._last || this._state == 4) {
            LOG.debug("Ignoring extra content {}", content);
            content.clear();
            return;
        }
        this._last = last;
        if (!this._endp.isOpen()) {
            this._state = 4;
            return;
        }
        if (this._content != null && this._content.length() > 0) {
            this.flushBuffer();
            if (this._content != null && this._content.length() > 0) {
                throw new IllegalStateException("FULL");
            }
        }
        this._content = content;
        this._contentWritten += (long)content.length();
        if (this._head) {
            content.clear();
            this._content = null;
        } else {
            this.initContent();
            int len = 0;
            len = this._buffer.put(this._content);
            if (len > 0 && this._buffer.space() == 0) {
                --len;
                this._buffer.setPutIndex(this._buffer.putIndex() - 1);
            }
            this._content.skip(len);
            if (this._content.length() == 0) {
                this._content = null;
            }
        }
    }

    public boolean addContent(byte b) throws IOException {
        if (this._noContent) {
            return false;
        }
        if (this._last || this._state == 4) {
            throw new IllegalStateException("Closed");
        }
        if (!this._endp.isOpen()) {
            this._state = 4;
            return false;
        }
        if (this._content != null && this._content.length() > 0) {
            this.flushBuffer();
            if (this._content != null && this._content.length() > 0) {
                throw new IllegalStateException("FULL");
            }
        }
        ++this._contentWritten;
        if (this._head) {
            return false;
        }
        this.initContent();
        this._buffer.put(b);
        return this._buffer.space() <= 1;
    }

    private void initContent() throws IOException {
        if (this._buffer == null) {
            this._buffer = this._buffers.getBuffer();
        }
    }

    public boolean isRequest() {
        return false;
    }

    public boolean isResponse() {
        return true;
    }

    public int prepareUncheckedAddContent() throws IOException {
        this.initContent();
        return this._buffer.space();
    }

    public void completeHeader(HttpFields fields, boolean allContentAdded) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("completeHeader: {}", fields.toString().trim().replace("\r\n", "|"));
        }
        if (this._state != 0) {
            return;
        }
        if (this._last && !allContentAdded) {
            throw new IllegalStateException("last?");
        }
        this._last |= allContentAdded;
        if (this._persistent == null) {
            this._persistent = this._version > 10;
        }
        if (this._reason == null) {
            this._response.setStatus(this._status);
        } else {
            this._response.setStatus(this._status, this._reason.toString());
        }
        if (this._status == 100 || this._status == 204 || this._status == 304) {
            this._noContent = true;
            this._content = null;
        }
        boolean has_server = false;
        if (fields != null) {
            int s = fields.size();
            for (int f = 0; f < s; ++f) {
                HttpFields.Field field = fields.getField(f);
                if (field == null) continue;
                this._response.setHeader(field.getName(), field.getValue());
            }
        }
        if (!has_server && this._status > 100 && this.getSendServerVersion()) {
            this._response.setHeader("Server", "Jetty(" + Server.getVersion() + ",nested in " + this._nestedIn + ")");
        }
        this._state = 2;
    }

    public long flushBuffer() throws IOException {
        if (this._state == 0) {
            throw new IllegalStateException("State==HEADER");
        }
        if (this._content != null && this._content.length() < this._buffer.space() && this._state != 3) {
            this.initContent();
            this._buffer.put(this._content);
            this._content.clear();
            this._content = null;
        }
        if (this._buffer == null) {
            return 0L;
        }
        int size = this._buffer.length();
        int len = this._buffer == null ? 0 : this._endp.flush(this._buffer);
        LOG.debug("flushBuffer {} of {}", len, size);
        if (len > 0) {
            this._buffer.skip(len);
        }
        return len;
    }
}

