/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;

public class SimpleCNN
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;

    private SimpleCNN() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return MultiLayerNetwork.class;
    }

    public MultiLayerConfiguration conf() {
        MultiLayerConfiguration conf = new NeuralNetConfiguration.Builder().seed(this.seed).activation(Activation.IDENTITY).weightInit(WeightInit.RELU).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).convolutionMode(ConvolutionMode.Same).list().layer(0, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{7, 7}).name("image_array")).nIn(this.inputShape[0])).nOut(16)).build()).layer(1, (Layer)new BatchNormalization.Builder().build()).layer(2, (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{7, 7}).nIn(16)).nOut(16)).build()).layer(3, (Layer)new BatchNormalization.Builder().build()).layer(4, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(5, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(6, (Layer)new DropoutLayer.Builder(0.5).build()).layer(7, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{5, 5}).nOut(32)).build()).layer(8, (Layer)new BatchNormalization.Builder().build()).layer(9, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{5, 5}).nOut(32)).build()).layer(10, (Layer)new BatchNormalization.Builder().build()).layer(11, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(12, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(13, (Layer)new DropoutLayer.Builder(0.5).build()).layer(14, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(64)).build()).layer(15, (Layer)new BatchNormalization.Builder().build()).layer(16, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(64)).build()).layer(17, (Layer)new BatchNormalization.Builder().build()).layer(18, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(19, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(20, (Layer)new DropoutLayer.Builder(0.5).build()).layer(21, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(128)).build()).layer(22, (Layer)new BatchNormalization.Builder().build()).layer(23, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(128)).build()).layer(24, (Layer)new BatchNormalization.Builder().build()).layer(25, (Layer)new ActivationLayer.Builder().activation(Activation.RELU).build()).layer(26, (Layer)new SubsamplingLayer.Builder(SubsamplingLayer.PoolingType.AVG, new int[]{2, 2}).build()).layer(27, (Layer)new DropoutLayer.Builder(0.5).build()).layer(28, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(256)).build()).layer(29, (Layer)new BatchNormalization.Builder().build()).layer(30, (Layer)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).nOut(this.numClasses)).build()).layer(31, (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build()).layer(32, (Layer)new ActivationLayer.Builder().activation(Activation.SOFTMAX).build()).setInputType(InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])).build();
        return conf;
    }

    public Model init() {
        MultiLayerNetwork network = new MultiLayerNetwork(this.conf());
        network.init();
        return network;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 48, 48};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static IUpdater $default$updater() {
        return new AdaDelta();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.NONE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    public static SimpleCNNBuilder builder() {
        return new SimpleCNNBuilder();
    }

    public SimpleCNN(long seed, int[] inputShape, int numClasses, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
    }

    public static class SimpleCNNBuilder {
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;

        SimpleCNNBuilder() {
        }

        public SimpleCNNBuilder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public SimpleCNNBuilder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public SimpleCNNBuilder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public SimpleCNNBuilder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public SimpleCNNBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public SimpleCNNBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public SimpleCNNBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public SimpleCNN build() {
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = SimpleCNN.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = SimpleCNN.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = SimpleCNN.$default$numClasses();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = SimpleCNN.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = SimpleCNN.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = SimpleCNN.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = SimpleCNN.$default$cudnnAlgoMode();
            }
            return new SimpleCNN(seed$value, inputShape$value, numClasses$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value);
        }

        public String toString() {
            return "SimpleCNN.SimpleCNNBuilder(seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ")";
        }
    }
}

