/*
 * Decompiled with CFR 0.152.
 */
package org.debux.webmotion.shiro;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.subject.WebSubject;
import org.debux.webmotion.server.WebMotionFilter;
import org.debux.webmotion.server.call.Call;
import org.debux.webmotion.server.call.HttpContext;
import org.debux.webmotion.server.mapping.FilterRule;
import org.debux.webmotion.server.render.Render;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shiro
extends WebMotionFilter {
    private static final Logger log = LoggerFactory.getLogger(Shiro.class);

    public Subject getSubject(HttpContext context) {
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        WebSubject subject = new WebSubject.Builder((ServletRequest)request, (ServletResponse)response).buildWebSubject();
        return subject;
    }

    public Render login(HttpContext context, String username, String password, Boolean rememberMe, String redirect) {
        Subject currentUser = this.getSubject(context);
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        if (rememberMe != null) {
            token.setRememberMe(rememberMe.booleanValue());
        }
        try {
            currentUser.login((AuthenticationToken)token);
        }
        catch (AuthenticationException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (redirect != null && !redirect.isEmpty()) {
            return this.renderURL(redirect, new Object[0]);
        }
        return this.renderJSON(new Object[]{currentUser.getPrincipal()});
    }

    public Render logout(HttpContext context, String redirect) {
        try {
            Subject currentUser = this.getSubject(context);
            currentUser.logout();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (redirect != null && !redirect.isEmpty()) {
            return this.renderURL(redirect, new Object[0]);
        }
        return this.renderSuccess();
    }

    public Render isAuthenticated(HttpContext context, String username, String password, Boolean rememberMe) {
        Subject currentUser = this.getSubject(context);
        if (!currentUser.isAuthenticated()) {
            if (username != null && !username.isEmpty()) {
                UsernamePasswordToken token = new UsernamePasswordToken(username, password);
                if (rememberMe != null) {
                    token.setRememberMe(rememberMe.booleanValue());
                }
                try {
                    currentUser.login((AuthenticationToken)token);
                    this.doProcess();
                    return null;
                }
                catch (AuthenticationException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            return this.renderError(401);
        }
        this.doProcess();
        return null;
    }

    public Render hasRole(HttpContext context, Call call) {
        FilterRule rule = (FilterRule)call.getCurrentRule();
        Map defaultParameters = rule.getDefaultParameters();
        String[] values = (String[])defaultParameters.get("role");
        List<String> roles = Arrays.asList(values);
        Subject currentUser = this.getSubject(context);
        if (currentUser.isAuthenticated()) {
            boolean[] hasRoles = currentUser.hasRoles(roles);
            if (BooleanUtils.and((boolean[])hasRoles)) {
                this.doProcess();
                return null;
            }
            return this.renderError(403);
        }
        return this.renderError(401);
    }

    public Render isPermitted(HttpContext context, Call call) {
        FilterRule rule = (FilterRule)call.getCurrentRule();
        Map defaultParameters = rule.getDefaultParameters();
        String[] permissions = (String[])defaultParameters.get("permission");
        Subject currentUser = this.getSubject(context);
        if (currentUser.isAuthenticated()) {
            boolean[] permitted = currentUser.isPermitted(permissions);
            if (BooleanUtils.and((boolean[])permitted)) {
                this.doProcess();
                return null;
            }
            return this.renderError(403);
        }
        return this.renderError(401);
    }
}

