/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.maven;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.Commandline;
import org.datanucleus.maven.AbstractDataNucleusMojo;

public abstract class AbstractSchemaToolMojo
extends AbstractDataNucleusMojo {
    private static final String TOOL_NAME_SCHEMA_TOOL = "org.datanucleus.store.schema.SchemaTool";
    private String props;
    private Properties toolProperties;

    protected void executeDataNucleusTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        this.executeSchemaTool(pluginArtifacts, files);
    }

    private void executeSchemaTool(List pluginArtifacts, List files) throws CommandLineException, MojoExecutionException {
        URL log4jURL;
        Commandline cl = new Commandline();
        cl.setExecutable("java");
        ArrayList<String> cpEntries = new ArrayList<String>();
        Iterator it = pluginArtifacts.iterator();
        while (it.hasNext()) {
            Artifact artifact = (Artifact)it.next();
            try {
                String artifactPath = artifact.getFile().getCanonicalPath();
                if (cpEntries.contains(artifactPath)) continue;
                cpEntries.add(artifactPath);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating the canonical path for '" + artifact.getFile() + "'.", (Exception)e);
            }
        }
        Iterator uniqueIter = this.getUniqueClasspathElements().iterator();
        while (uniqueIter.hasNext()) {
            String entry = (String)uniqueIter.next();
            if (cpEntries.contains(entry)) continue;
            cpEntries.add(entry);
        }
        StringBuffer cpBuffer = new StringBuffer();
        Iterator it2 = cpEntries.iterator();
        while (it2.hasNext()) {
            cpBuffer.append((String)it2.next());
            if (!it2.hasNext()) continue;
            cpBuffer.append(File.pathSeparator);
        }
        cl.createArgument().setValue("-cp");
        cl.createArgument().setValue(cpBuffer.toString());
        Properties systemProperties = System.getProperties();
        if (this.toolProperties != null) {
            String key;
            Set toolPropertyKeys = ((Hashtable)this.toolProperties).keySet();
            Iterator it3 = toolPropertyKeys.iterator();
            while (it3.hasNext()) {
                key = (String)it3.next();
                if (!((Hashtable)systemProperties).containsKey(key)) continue;
                ((Hashtable)this.toolProperties).put(key, systemProperties.getProperty(key));
                this.getLog().warn((CharSequence)("Property '" + key + "' value specified in pom configuration will be overridden."));
            }
            it3 = toolPropertyKeys.iterator();
            while (it3.hasNext()) {
                key = (String)it3.next();
                String val = null != this.toolProperties.getProperty(key) ? this.toolProperties.getProperty(key) : "";
                cl.createArgument().setValue("-D" + key + "=" + val);
            }
        }
        if ((log4jURL = this.getLog4JConfiguration()) != null) {
            cl.createArgument().setValue("-Dlog4j.configuration=" + log4jURL);
        } else {
            URL jdkLogURL = this.getJdkLogConfiguration();
            if (jdkLogURL != null) {
                cl.createArgument().setValue("-Djava.util.logging.config.file=" + jdkLogURL);
            }
        }
        cl.createArgument().setValue(TOOL_NAME_SCHEMA_TOOL);
        ArrayList<String> args = new ArrayList<String>();
        this.prepareModeSpecificCommandLineArguments(cl, args);
        if (this.verbose) {
            cl.createArgument().setValue("-v");
            args.add("-v");
        }
        if (this.persistenceUnitName != null && this.persistenceUnitName.trim().length() > 0) {
            cl.createArgument().setLine("-pu " + this.persistenceUnitName);
            args.add("-pu");
            args.add(this.persistenceUnitName);
        }
        cl.createArgument().setLine("-api " + this.api);
        args.add("-api");
        args.add(this.api);
        if (this.props != null) {
            cl.createArgument().setLine("-props " + this.props);
            args.add("-props");
            args.add(this.props);
        }
        Iterator it4 = files.iterator();
        while (it4.hasNext()) {
            File file = (File)it4.next();
            cl.createArgument().setValue(file.getAbsolutePath());
            args.add(file.getAbsolutePath());
        }
        this.executeCommandLine(cl);
    }

    protected abstract void prepareModeSpecificCommandLineArguments(Commandline var1, List var2);

    protected String getToolName() {
        return TOOL_NAME_SCHEMA_TOOL;
    }
}

