/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.expression.StringExpression;
import org.datanucleus.store.mapped.expression.StringLiteral;
import org.datanucleus.store.mapped.expression.TableExprAsSubjoins;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.key.PrimaryKey;
import org.datanucleus.store.rdbms.schema.InformixTypeInfo;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Table;
import org.datanucleus.util.NucleusLogger;

public class InformixAdapter
extends DatabaseAdapter {
    public InformixAdapter(DatabaseMetaData metadata) {
        super(metadata);
        this.supportedOptions.add("IdentityColumns");
        this.supportedOptions.add("ProjectionInTableReferenceJoins");
        this.supportedOptions.add("PrimaryKeyInCreateStatements");
        this.supportedOptions.add("CreateIndexesBeforeForeignKeys");
        this.supportedOptions.remove("AutoIncrementNullSpecification");
        this.supportedOptions.remove("AutoIncrementColumnTypeSpecification");
        this.supportedOptions.remove("ColumnOptions_NullsKeyword");
        this.supportedOptions.remove("DeferredConstraints");
    }

    public void initialiseDatastore(Object conn) {
        try {
            Statement st = ((Connection)conn).createStatement();
            try {
                st.execute(this.getSTRPOSDropFunction());
            }
            catch (SQLException e) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051027", (Object)e));
            }
            try {
                st.execute(this.getSTRPOSFunction());
            }
            catch (SQLException e) {
                NucleusLogger.DATASTORE.warn((Object)LOCALISER.msg("051027", (Object)e));
            }
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new NucleusDataStoreException(e.getMessage(), (Throwable)e);
        }
    }

    public String getVendorID() {
        return "informix";
    }

    public SQLTypeInfo newSQLTypeInfo(ResultSet rs) {
        return new InformixTypeInfo(rs);
    }

    public String getIdentifierQuoteString() {
        return "";
    }

    public String getAutoIncrementStmt(Table table, String columnName) {
        String useSerial = (String)this.getValueForProperty("datanucleus.rdbms.adapter.informixUseSerialForIdentity");
        if (useSerial != null && useSerial.equalsIgnoreCase("true")) {
            return "SELECT first 1 dbinfo('sqlca.sqlerrd1') from systables";
        }
        return "SELECT first 1 dbinfo('serial8') from systables";
    }

    public String getAutoIncrementKeyword() {
        String useSerial = (String)this.getValueForProperty("datanucleus.rdbms.adapter.informixUseSerialForIdentity");
        if (useSerial != null && useSerial.equalsIgnoreCase("true")) {
            return "SERIAL";
        }
        return "SERIAL8";
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public String getAddForeignKeyStatement(ForeignKey fk, IdentifierFactory factory) {
        if (fk.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(fk.getName());
            return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD CONSTRAINT" + ' ' + fk + ' ' + "CONSTRAINT" + ' ' + identifier;
        }
        return "ALTER TABLE " + fk.getDatastoreContainerObject().toString() + " ADD " + fk;
    }

    public String getAddCandidateKeyStatement(CandidateKey ck, IdentifierFactory factory) {
        if (ck.getName() != null) {
            String identifier = factory.getIdentifierInAdapterCase(ck.getName());
            return "ALTER TABLE " + ck.getDatastoreContainerObject().toString() + " ADD CONSTRAINT" + ' ' + ck + ' ' + "CONSTRAINT" + ' ' + identifier;
        }
        return "ALTER TABLE " + ck.getDatastoreContainerObject().toString() + " ADD " + ck;
    }

    public String getDatastoreDateStatement() {
        return "SELECT FIRST 1 (CURRENT) FROM SYSTABLES";
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsSubjoins(qs, table, rangeVar);
    }

    private String getSTRPOSFunction() {
        return "create function NUCLEUS_STRPOS(str char(40),search char(40),from smallint) returning smallint\ndefine i,pos,lenstr,lensearch smallint;\nlet lensearch = length(search);\nlet lenstr = length(str);\nif lenstr=0 or lensearch=0 then return 0; end if;\nlet pos=-1;\nfor i=1+from to lenstr\nif substr(str,i,lensearch)=search then\nlet pos=i;\nexit for;\nend if;\nend for;\nreturn pos;\nend function;";
    }

    private String getSTRPOSDropFunction() {
        return "drop function NUCLEUS_STRPOS;";
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(BigInteger.class, source).newLiteral(source.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        args.add(str);
        if (from != null) {
            args.add(from.add(integerLiteral));
        } else {
            ScalarExpression literal = this.getMapping(BigInteger.class, source).newLiteral(source.getQueryExpression(), (Object)BigInteger.ZERO);
            args.add(literal);
        }
        NumericExpression locateExpr = new NumericExpression("NUCLEUS_STRPOS", args);
        return new NumericExpression((ScalarExpression)locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public BooleanExpression startsWithMethod(ScalarExpression source, ScalarExpression str) {
        JavaTypeMapping m = this.getMapping(BigInteger.class, source);
        ScalarExpression integerLiteral = m.newLiteral(source.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        args.add(str);
        ScalarExpression literal = this.getMapping(BigInteger.class, source).newLiteral(source.getQueryExpression(), (Object)BigInteger.ZERO);
        args.add(literal);
        return new BooleanExpression((ScalarExpression)new StringExpression("NUCLEUS_STRPOS", args), ScalarExpression.OP_EQ, integerLiteral);
    }

    public BooleanExpression endsWithMethod(ScalarExpression leftOperand, ScalarExpression rightOperand) {
        if (!(rightOperand instanceof StringExpression)) {
            throw new ScalarExpression.IllegalArgumentTypeException(rightOperand);
        }
        JavaTypeMapping m = this.getMapping(BigInteger.class, leftOperand);
        ScalarExpression integerLiteral = m.newLiteral(leftOperand.getQueryExpression(), (Object)BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(leftOperand);
        args.add(rightOperand);
        ScalarExpression literal = this.getMapping(BigInteger.class, leftOperand).newLiteral(leftOperand.getQueryExpression(), (Object)BigInteger.ZERO);
        args.add(literal);
        return new BooleanExpression((ScalarExpression)new StringExpression("NUCLEUS_STRPOS", args), ScalarExpression.OP_EQ, this.getNumericExpressionForMethod("length", leftOperand).sub((ScalarExpression)this.getNumericExpressionForMethod("length", rightOperand)).add(integerLiteral).encloseWithInParentheses());
    }

    public NumericExpression getNumericExpressionForMethod(String method, ScalarExpression expr) {
        if (method.equalsIgnoreCase("hour")) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(expr);
            args.add(new StringLiteral(expr.getQueryExpression(), null, "%I"));
            ArrayList<StringExpression> args0 = new ArrayList<StringExpression>();
            args0.add(new StringExpression("TO_CHAR", args));
            ArrayList<String> types = new ArrayList<String>();
            types.add("INTEGER");
            return new NumericExpression("CAST", args0, types);
        }
        if (method.equalsIgnoreCase("minute")) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(expr);
            args.add(new StringLiteral(expr.getQueryExpression(), null, "%M"));
            ArrayList<StringExpression> args0 = new ArrayList<StringExpression>();
            args0.add(new StringExpression("TO_CHAR", args));
            ArrayList<String> types = new ArrayList<String>();
            types.add("INTEGER");
            return new NumericExpression("CAST", args0, types);
        }
        if (method.equalsIgnoreCase("second")) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(expr);
            args.add(new StringLiteral(expr.getQueryExpression(), null, "%S"));
            ArrayList<StringExpression> args0 = new ArrayList<StringExpression>();
            args0.add(new StringExpression("TO_CHAR", args));
            ArrayList<String> types = new ArrayList<String>();
            types.add("INTEGER");
            return new NumericExpression("CAST", args0, types);
        }
        return super.getNumericExpressionForMethod(method, expr);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, (ScalarExpression)str).newLiteral(str.getQueryExpression(), (Object)BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(str);
        args.add(begin.add(this.getMapping(BigInteger.class, (ScalarExpression)str).newLiteral(str.getQueryExpression(), (Object)BigInteger.ONE)));
        args.add(end.sub((ScalarExpression)begin));
        return new StringExpression("SUBSTR", args);
    }

    public NumericExpression modOperator(ScalarExpression operand1, ScalarExpression operand2) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(operand1);
        args.add(operand2);
        return new NumericExpression("MOD", args);
    }
}

