/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.Arrays;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.updatecenter.common.Artifact;
import org.sonar.updatecenter.common.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Release
implements Comparable<Release> {
    private Artifact artifact;
    private Version version;
    private String description;
    private String downloadUrl;
    private String changelogUrl;
    private SortedSet<Version> requiredSonarVersions = new TreeSet<Version>();
    private Date date;

    public Release(Artifact artifact, Version version) {
        this.artifact = artifact;
        this.version = version;
    }

    public Release(Artifact artifact, String version) {
        this.artifact = artifact;
        this.version = Version.create(version);
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Version getVersion() {
        return this.version;
    }

    public Release setVersion(Version version) {
        this.version = version;
        return this;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Release setDownloadUrl(String s) {
        this.downloadUrl = s;
        return this;
    }

    public String getFilename() {
        return StringUtils.substringAfterLast((String)this.downloadUrl, (String)"/");
    }

    public SortedSet<Version> getRequiredSonarVersions() {
        return this.requiredSonarVersions;
    }

    public boolean supportSonarVersion(Version version) {
        return this.requiredSonarVersions.contains(version);
    }

    public Release addRequiredSonarVersions(Version ... versions) {
        if (versions != null) {
            this.requiredSonarVersions.addAll(Arrays.asList(versions));
        }
        return this;
    }

    public Release addRequiredSonarVersions(String ... versions) {
        if (versions != null) {
            for (String v : versions) {
                this.requiredSonarVersions.add(Version.create(v));
            }
        }
        return this;
    }

    public Version getLastRequiredSonarVersion() {
        if (this.requiredSonarVersions != null && !this.requiredSonarVersions.isEmpty()) {
            return this.requiredSonarVersions.last();
        }
        return null;
    }

    public Version getMinimumRequiredSonarVersion() {
        if (this.requiredSonarVersions != null && !this.requiredSonarVersions.isEmpty()) {
            return this.requiredSonarVersions.first();
        }
        return null;
    }

    public Date getDate() {
        return this.date;
    }

    public Release setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Release setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getChangelogUrl() {
        return this.changelogUrl;
    }

    public Release setChangelogUrl(String changelogUrl) {
        this.changelogUrl = changelogUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Release that = (Release)o;
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("version", (Object)this.version).append("downloadUrl", (Object)this.downloadUrl).append("changelogUrl", (Object)this.changelogUrl).append("description", (Object)this.description).toString();
    }

    @Override
    public int compareTo(Release o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

