/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem.internal;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.scan.filesystem.internal.DefaultInputFile;
import org.sonar.api.utils.PathUtils;

public class InputFileBuilder {
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final File file;
    private final String relativePath;

    public static void _FOR_UNIT_TESTING_ONLY_() {
    }

    public InputFileBuilder(File file, String relativePath) {
        this.file = file;
        this.relativePath = relativePath;
    }

    public InputFileBuilder attribute(String key, @Nullable String value) {
        if (value != null) {
            this.attributes.put(key, value);
        }
        return this;
    }

    public InputFileBuilder type(@Nullable String type) {
        return this.attribute("TYPE", type);
    }

    public InputFileBuilder language(@Nullable String language) {
        return this.attribute("LANG", language);
    }

    public InputFileBuilder hash(@Nullable String hash) {
        return this.attribute("HASH", hash);
    }

    public InputFileBuilder status(@Nullable String status) {
        return this.attribute("STATUS", status);
    }

    public InputFileBuilder sourceDir(File dir) {
        return this.attribute("SRC_DIR_PATH", PathUtils.canonicalPath(dir));
    }

    public InputFileBuilder sourceDir(@Nullable String path) {
        return this.attribute("SRC_DIR_PATH", PathUtils.sanitize(path));
    }

    public DefaultInputFile build() {
        return DefaultInputFile.create(this.file, this.relativePath, this.attributes);
    }
}

