/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.profiles;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.sonar.api.database.BaseIdentifiable;
import org.sonar.api.measures.Metric;
import org.sonar.api.profiles.RulesProfile;

@Entity
@Table(name="alerts")
public class Alert
extends BaseIdentifiable
implements Cloneable {
    public static final String OPERATOR_GREATER = ">";
    public static final String OPERATOR_SMALLER = "<";
    public static final String OPERATOR_EQUALS = "=";
    public static final String OPERATOR_NOT_EQUALS = "!=";
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="profile_id")
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private RulesProfile rulesProfile;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="metric_id", nullable=true)
    @Cache(usage=CacheConcurrencyStrategy.READ_ONLY)
    private Metric metric;
    @Column(name="operator", updatable=false, nullable=true, length=3)
    private String operator;
    @Column(name="value_error", updatable=false, nullable=true, length=64)
    private String valueError;
    @Column(name="value_warning", updatable=false, nullable=true, length=64)
    private String valueWarning;
    @Column(name="period", updatable=false, nullable=true)
    private Integer period;

    public Alert() {
    }

    public Alert(RulesProfile rulesProfile, Metric metric, String operator, String valueError, String valueWarning) {
        this.rulesProfile = rulesProfile;
        this.metric = metric;
        this.operator = operator;
        this.valueError = valueError;
        this.valueWarning = valueWarning;
    }

    public Alert(RulesProfile rulesProfile, Metric metric, String operator, String valueError, String valueWarning, Integer period) {
        this(rulesProfile, metric, operator, valueError, valueWarning);
        this.period = period;
    }

    public RulesProfile getRulesProfile() {
        return this.rulesProfile;
    }

    public void setRulesProfile(RulesProfile rulesProfile) {
        this.rulesProfile = rulesProfile;
    }

    public Metric getMetric() {
        return this.metric;
    }

    public void setMetric(Metric metric) {
        this.metric = metric;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getValueError() {
        return this.valueError;
    }

    public void setValueError(String valueError) {
        this.valueError = valueError;
    }

    public String getValueWarning() {
        return this.valueWarning;
    }

    public void setValueWarning(String valueWarning) {
        this.valueWarning = valueWarning;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public boolean isGreaterOperator() {
        return this.operator.equals(OPERATOR_GREATER);
    }

    public boolean isSmallerOperator() {
        return this.operator.equals(OPERATOR_SMALLER);
    }

    public boolean isEqualsOperator() {
        return this.operator.equals(OPERATOR_EQUALS);
    }

    public boolean isNotEqualsOperator() {
        return this.operator.equals(OPERATOR_NOT_EQUALS);
    }

    @Deprecated
    public String getAlertLabel(Metric.Level level) {
        return this.getMetric().getName() + " " + this.getOperator() + " " + (level.equals((Object)Metric.Level.ERROR) ? this.getValueError() : this.getValueWarning());
    }

    public Object clone() {
        return new Alert(this.getRulesProfile(), this.getMetric(), this.getOperator(), this.getValueError(), this.getValueWarning(), this.getPeriod());
    }
}

