/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.sonar.api.resources.DefaultProjectFileSystem;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.WildcardPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
extends Resource<Directory> {
    public static final String SCOPE = "FIL";
    private String directoryKey;
    private String filename;
    private Language language;
    private Directory parent;
    private String qualifier = "FIL";

    public File(String key) {
        if (key == null) {
            throw new IllegalArgumentException("File key is null");
        }
        String realKey = File.parseKey(key);
        if (realKey.indexOf("/") >= 0) {
            this.directoryKey = Directory.parseKey(StringUtils.substringBeforeLast((String)key, (String)"/"));
            this.filename = StringUtils.substringAfterLast((String)realKey, (String)"/");
            realKey = this.directoryKey + "/" + this.filename;
        } else {
            this.filename = key;
        }
        this.setKey(realKey);
    }

    public File(String directory, String filename) {
        this.filename = StringUtils.trim((String)filename);
        if (StringUtils.isBlank((String)directory)) {
            this.setKey(filename);
        } else {
            this.directoryKey = Directory.parseKey(directory);
            this.setKey(this.directoryKey + "/" + this.filename);
        }
    }

    public File(Language language, String key) {
        this(key);
        this.language = language;
    }

    public File(Language language, String directory, String filename) {
        this(directory, filename);
        this.language = language;
    }

    @Override
    public Directory getParent() {
        if (this.parent == null) {
            this.parent = new Directory(this.directoryKey);
        }
        return this.parent;
    }

    private static String parseKey(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        key = key.replace('\\', '/');
        key = StringUtils.trim((String)key);
        return key;
    }

    @Override
    public boolean matchFilePattern(String antPattern) {
        WildcardPattern matcher = WildcardPattern.create(antPattern, "/");
        return matcher.match(this.getKey());
    }

    public static File fromIOFile(java.io.File file, List<java.io.File> sourceDirs) {
        String relativePath = DefaultProjectFileSystem.getRelativePath(file, sourceDirs);
        if (relativePath != null) {
            return new File(relativePath);
        }
        return null;
    }

    public static File fromIOFile(java.io.File file, Project project) {
        return File.fromIOFile(file, project.getFileSystem().getSourceDirs());
    }

    @Override
    public String getName() {
        return this.filename;
    }

    @Override
    public String getLongName() {
        return this.getKey();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @Override
    public final String getScope() {
        return SCOPE;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.getKey()).append("dir", (Object)this.directoryKey).append("filename", (Object)this.filename).append("language", (Object)this.language).toString();
    }
}

