/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.ServerComponent;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.utils.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings
implements BatchComponent,
ServerComponent {
    protected Map<String, String> properties = Maps.newHashMap();
    protected PropertyDefinitions definitions;

    public Settings() {
        this(new PropertyDefinitions(new Object[0]));
    }

    public Settings(PropertyDefinitions definitions) {
        this.definitions = definitions;
    }

    public final String getDefaultValue(String key) {
        return this.definitions.getDefaultValue(key);
    }

    public final boolean hasKey(String key) {
        return this.properties.containsKey(key);
    }

    public final boolean hasDefaultValue(String key) {
        return StringUtils.isNotEmpty((String)this.getDefaultValue(key));
    }

    public final String getString(String key) {
        String value = this.properties.get(key);
        if (value == null) {
            value = this.getDefaultValue(key);
        }
        return value;
    }

    public final boolean getBoolean(String key) {
        String value = this.getString(key);
        return StringUtils.isNotEmpty((String)value) && Boolean.parseBoolean(value);
    }

    public final int getInt(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public final long getLong(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return Long.parseLong(value);
        }
        return 0L;
    }

    public final Date getDate(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return DateUtils.parseDate(value);
        }
        return null;
    }

    public final Date getDateTime(String key) {
        String value = this.getString(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return DateUtils.parseDateTime(value);
        }
        return null;
    }

    public final String[] getStringArray(String key) {
        return this.getStringArrayBySeparator(key, ",");
    }

    public final String[] getStringArrayBySeparator(String key, String separator) {
        String value = this.getString(key);
        if (value != null) {
            String[] strings = StringUtils.splitByWholeSeparator((String)value, (String)separator);
            String[] result = new String[strings.length];
            for (int index = 0; index < strings.length; ++index) {
                result[index] = StringUtils.trim((String)strings[index]);
            }
            return result;
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public List<String> getKeysStartingWith(String prefix) {
        ArrayList result = Lists.newArrayList();
        for (String key : this.properties.keySet()) {
            if (!StringUtils.startsWith((String)key, (String)prefix)) continue;
            result.add(key);
        }
        return result;
    }

    public final Settings appendProperty(String key, String value) {
        String newValue = this.properties.get(key);
        newValue = StringUtils.isEmpty((String)newValue) ? value : newValue + "," + value;
        this.properties.put(key, newValue);
        return this;
    }

    public final Settings setProperty(String key, String value) {
        if (!this.clearIfNullValue(key, value)) {
            this.properties.put(key, value);
        }
        return this;
    }

    public final Settings setProperty(String key, Boolean value) {
        if (!this.clearIfNullValue(key, value)) {
            this.properties.put(key, String.valueOf(value));
        }
        return this;
    }

    public final Settings setProperty(String key, Integer value) {
        if (!this.clearIfNullValue(key, value)) {
            this.properties.put(key, String.valueOf(value));
        }
        return this;
    }

    public final Settings setProperty(String key, Long value) {
        if (!this.clearIfNullValue(key, value)) {
            this.properties.put(key, String.valueOf(value));
        }
        return this;
    }

    public final Settings setProperty(String key, Double value) {
        if (!this.clearIfNullValue(key, value)) {
            this.properties.put(key, String.valueOf(value));
        }
        return this;
    }

    public final Settings setProperty(String key, Date date) {
        return this.setProperty(key, date, false);
    }

    public final Settings addProperties(Map<String, String> props) {
        this.properties.putAll(props);
        return this;
    }

    public final Settings addProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return this;
    }

    public final Settings addSystemProperties() {
        return this.addProperties(System.getProperties());
    }

    public final Settings addEnvironmentVariables() {
        return this.addProperties(System.getenv());
    }

    public final Settings setProperties(Map<String, String> props) {
        this.properties = Maps.newHashMap(props);
        return this;
    }

    public final Settings setProperty(String key, Date date, boolean includeTime) {
        if (!this.clearIfNullValue(key, date)) {
            this.properties.put(key, includeTime ? DateUtils.formatDateTime(date) : DateUtils.formatDate(date));
        }
        return this;
    }

    public final Settings removeProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    public final Settings clear() {
        this.properties.clear();
        return this;
    }

    public final Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public final PropertyDefinitions getDefinitions() {
        return this.definitions;
    }

    private boolean clearIfNullValue(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
            return true;
        }
        return false;
    }

    public static Settings createForComponent(Object component) {
        return new Settings(new PropertyDefinitions(component));
    }
}

