/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.measures;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.utils.KeyValueFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CoverageMeasuresBuilder {
    public static final List<Metric> METRICS = Arrays.asList(CoreMetrics.LINES_TO_COVER, CoreMetrics.UNCOVERED_LINES, CoreMetrics.COVERAGE_LINE_HITS_DATA, CoreMetrics.CONDITIONS_TO_COVER, CoreMetrics.UNCOVERED_CONDITIONS, CoreMetrics.CONDITIONS_BY_LINE, CoreMetrics.COVERED_CONDITIONS_BY_LINE);
    private int totalCoveredLines = 0;
    private int totalConditions = 0;
    private int totalCoveredConditions = 0;
    private SortedMap<Integer, Integer> hitsByLine = Maps.newTreeMap();
    private SortedMap<Integer, Integer> conditionsByLine = Maps.newTreeMap();
    private SortedMap<Integer, Integer> coveredConditionsByLine = Maps.newTreeMap();

    private CoverageMeasuresBuilder() {
    }

    public CoverageMeasuresBuilder reset() {
        this.totalCoveredLines = 0;
        this.totalConditions = 0;
        this.totalCoveredConditions = 0;
        this.hitsByLine.clear();
        this.conditionsByLine.clear();
        this.coveredConditionsByLine.clear();
        return this;
    }

    public CoverageMeasuresBuilder setHits(int lineId, int hits) {
        if (!this.hitsByLine.containsKey(lineId)) {
            this.hitsByLine.put(lineId, hits);
            if (hits > 0) {
                ++this.totalCoveredLines;
            }
        }
        return this;
    }

    public CoverageMeasuresBuilder setConditions(int lineId, int conditions, int coveredConditions) {
        if (!this.conditionsByLine.containsKey(lineId) && conditions > 0) {
            this.totalConditions += conditions;
            this.totalCoveredConditions += coveredConditions;
            this.conditionsByLine.put(lineId, conditions);
            this.coveredConditionsByLine.put(lineId, coveredConditions);
        }
        return this;
    }

    public int getCoveredLines() {
        return this.totalCoveredLines;
    }

    public int getLinesToCover() {
        return this.hitsByLine.size();
    }

    public int getConditions() {
        return this.totalConditions;
    }

    public int getCoveredConditions() {
        return this.totalCoveredConditions;
    }

    public SortedMap<Integer, Integer> getHitsByLine() {
        return Collections.unmodifiableSortedMap(this.hitsByLine);
    }

    public SortedMap<Integer, Integer> getConditionsByLine() {
        return Collections.unmodifiableSortedMap(this.conditionsByLine);
    }

    public SortedMap<Integer, Integer> getCoveredConditionsByLine() {
        return Collections.unmodifiableSortedMap(this.coveredConditionsByLine);
    }

    public Collection<Measure> createMeasures() {
        ArrayList measures = Lists.newArrayList();
        if (this.getLinesToCover() > 0) {
            measures.add(new Measure(CoreMetrics.LINES_TO_COVER, Double.valueOf(this.getLinesToCover())));
            measures.add(new Measure(CoreMetrics.UNCOVERED_LINES, Double.valueOf(this.getLinesToCover() - this.getCoveredLines())));
            measures.add(new Measure(CoreMetrics.COVERAGE_LINE_HITS_DATA).setData(KeyValueFormat.format(this.hitsByLine)).setPersistenceMode(PersistenceMode.DATABASE));
        }
        if (this.getConditions() > 0) {
            measures.add(new Measure(CoreMetrics.CONDITIONS_TO_COVER, Double.valueOf(this.getConditions())));
            measures.add(new Measure(CoreMetrics.UNCOVERED_CONDITIONS, Double.valueOf(this.getConditions() - this.getCoveredConditions())));
            measures.add(this.createConditionsByLine());
            measures.add(this.createCoveredConditionsByLine());
        }
        return measures;
    }

    private Measure createCoveredConditionsByLine() {
        return new Measure(CoreMetrics.COVERED_CONDITIONS_BY_LINE).setData(KeyValueFormat.format(this.coveredConditionsByLine)).setPersistenceMode(PersistenceMode.DATABASE);
    }

    private Measure createConditionsByLine() {
        return new Measure(CoreMetrics.CONDITIONS_BY_LINE).setData(KeyValueFormat.format(this.conditionsByLine)).setPersistenceMode(PersistenceMode.DATABASE);
    }

    public static CoverageMeasuresBuilder create() {
        return new CoverageMeasuresBuilder();
    }
}

