/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;

public final class CommandExecutor {
    private static final CommandExecutor INSTANCE = new CommandExecutor();

    private CommandExecutor() {
    }

    public static CommandExecutor create() {
        return INSTANCE;
    }

    public int execute(Command command, long timeoutMilliseconds) {
        ExecutorService executorService = null;
        Process process = null;
        try {
            LoggerFactory.getLogger(this.getClass()).debug("Executing command: " + command);
            ProcessBuilder builder = new ProcessBuilder(command.toStrings());
            if (command.getDirectory() != null) {
                builder.directory(command.getDirectory());
            }
            process = builder.start();
            StreamGobbler outputGobbler = new StreamGobbler(process.getInputStream());
            StreamGobbler errorGobbler = new StreamGobbler(process.getErrorStream());
            outputGobbler.start();
            errorGobbler.start();
            final Process finalProcess = process;
            Callable<Integer> call = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    finalProcess.waitFor();
                    return finalProcess.exitValue();
                }
            };
            executorService = Executors.newSingleThreadExecutor();
            Future<Integer> ft = executorService.submit(call);
            int n = ft.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
            return n;
        }
        catch (TimeoutException te) {
            process.destroy();
            throw new CommandException(command, "Timeout exceeded: " + timeoutMilliseconds + " ms", te);
        }
        catch (Exception e) {
            throw new CommandException(command, (Throwable)e);
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    private static class StreamGobbler
    extends Thread {
        InputStream is;

        StreamGobbler(InputStream is) {
            this.is = is;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Logger logger = LoggerFactory.getLogger(CommandExecutor.class);
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    logger.info(line);
                }
            }
            catch (IOException ioe) {
                logger.error("Error while reading stream", (Throwable)ioe);
            }
            finally {
                IOUtils.closeQuietly((Reader)br);
                IOUtils.closeQuietly((Reader)isr);
            }
        }
    }
}

