/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.Event;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.DuplicatedSourceException;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectLink;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.api.violations.ViolationQuery;
import org.sonar.graph.DirectedGraphAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SonarIndex
implements DirectedGraphAccessor<Resource, Dependency> {
    public abstract boolean index(Resource var1);

    public abstract boolean index(Resource var1, Resource var2);

    public abstract boolean isExcluded(Resource var1);

    public abstract boolean isIndexed(Resource var1, boolean var2);

    public abstract <R extends Resource> R getResource(R var1);

    public abstract Resource getParent(Resource var1);

    public abstract Collection<Resource> getChildren(Resource var1);

    public abstract void setSource(Resource var1, String var2) throws DuplicatedSourceException;

    public abstract String getSource(Resource var1);

    public abstract Project getProject();

    public final Collection<Resource> getResources() {
        return this.getVertices();
    }

    @Deprecated
    public abstract Resource addResource(Resource var1);

    public abstract Measure getMeasure(Resource var1, Metric var2);

    public abstract <M> M getMeasures(Resource var1, MeasuresFilter<M> var2);

    public abstract List<Violation> getViolations(ViolationQuery var1);

    public final List<Violation> getViolations(Resource resource) {
        return this.getViolations(ViolationQuery.create().forResource(resource));
    }

    public abstract void addViolation(Violation var1, boolean var2);

    public final void addViolation(Violation violation) {
        this.addViolation(violation, false);
    }

    public abstract Measure addMeasure(Resource var1, Measure var2);

    public abstract Dependency addDependency(Dependency var1);

    public abstract Set<Dependency> getDependencies();

    public abstract void addLink(ProjectLink var1);

    public abstract void deleteLink(String var1);

    public abstract List<Event> getEvents(Resource var1);

    public abstract void deleteEvent(Event var1);

    public abstract Event addEvent(Resource var1, String var2, String var3, String var4, Date var5);

    public final Collection<Dependency> getOutgoingDependencies(Resource from) {
        return this.getOutgoingEdges(from);
    }

    public final Collection<Dependency> getIncomingDependencies(Resource to) {
        return this.getIncomingEdges(to);
    }
}

