/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.statement;

import java.util.ArrayList;
import java.util.List;
import org.sonar.duplications.DuplicationsException;
import org.sonar.duplications.statement.Statement;
import org.sonar.duplications.statement.StatementChannel;
import org.sonar.duplications.statement.StatementChannelDisptacher;
import org.sonar.duplications.statement.matcher.TokenMatcher;
import org.sonar.duplications.token.TokenQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatementChunker {
    private final StatementChannelDisptacher channelDispatcher;

    public static Builder builder() {
        return new Builder();
    }

    private StatementChunker(Builder builder) {
        this.channelDispatcher = builder.getChannelDispatcher();
    }

    public List<Statement> chunk(TokenQueue tokenQueue) {
        if (tokenQueue == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<Statement> statements = new ArrayList<Statement>();
        try {
            this.channelDispatcher.consume(tokenQueue, statements);
            return statements;
        }
        catch (Exception e) {
            throw new DuplicationsException("Unable to build statement from token : " + tokenQueue.peek(), e);
        }
    }

    public static final class Builder {
        private List<StatementChannel> channels = new ArrayList<StatementChannel>();

        private Builder() {
        }

        public StatementChunker build() {
            return new StatementChunker(this);
        }

        public Builder ignore(TokenMatcher ... matchers) {
            this.channels.add(StatementChannel.createBlackHole(matchers));
            return this;
        }

        public Builder statement(TokenMatcher ... matchers) {
            this.channels.add(StatementChannel.create(matchers));
            return this;
        }

        private StatementChannelDisptacher getChannelDispatcher() {
            return new StatementChannelDisptacher(this.channels);
        }
    }
}

