/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.entity;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Image;
import java.io.IOException;
import java.net.MalformedURLException;
import org.sonar.report.pdf.util.Logger;

public class RadarGraphic {
    private String efficiency;
    private String maintainability;
    private String portability;
    private String reliavility;
    private String usability;
    private String sonarUrl;

    public RadarGraphic(String efficiency, String maintainability, String portability, String reliavility, String usability, String sonarUrl) {
        this.efficiency = efficiency;
        this.maintainability = maintainability;
        this.portability = portability;
        this.reliavility = reliavility;
        this.usability = usability;
        this.sonarUrl = sonarUrl;
    }

    public Image getGraphic() {
        Image image = null;
        try {
            String requestUrl = this.sonarUrl + "/chart?ck=xradar&w=210&h=110&c=777777|F8A036&m=100&g=0.25&" + "l=Eff.(" + this.efficiency + "%25),Mai.(" + this.maintainability + "%25),Por.(" + this.portability + "%25),Rel.(" + this.reliavility + "%25),Usa.(" + this.usability + "%25)&" + "v=" + this.efficiency + "," + this.maintainability + "," + this.portability + "," + this.reliavility + "," + this.usability;
            Logger.debug("Getting radar graphic: " + requestUrl);
            image = Image.getInstance((String)requestUrl);
            image.setAlignment(5);
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }
}

