/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf.entity;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfo {
    private String key;
    private String name;
    private String violations;
    private String complexity;
    private String duplicatedLines;
    private static final String ALL_FILES = "/resources/resource";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private static final String VIOLATIONS_NUMBER = "msr/frmt_val";
    private static final String CCN = "msr/frmt_val";
    private static final String DUPLICATED_LINES = "msr/frmt_val";
    public static final int VIOLATIONS_CONTENT = 1;
    public static final int CCN_CONTENT = 2;
    public static final int DUPLICATIONS_CONTENT = 3;

    public void initFromNode(Node fileNode, int content) {
        this.setKey(fileNode.selectSingleNode(KEY).getText());
        this.setName(fileNode.selectSingleNode(NAME).getText());
        if (content == 1) {
            this.setViolations(fileNode.selectSingleNode("msr/frmt_val").getText());
        } else if (content == 2) {
            this.setComplexity(fileNode.selectSingleNode("msr/frmt_val").getText());
        } else if (content == 3) {
            this.setDuplicatedLines(fileNode.selectSingleNode("msr/frmt_val").getText());
        }
    }

    public static List<FileInfo> initFromDocument(Document filesDocument, int content) {
        List fileNodes = filesDocument.selectNodes(ALL_FILES);
        LinkedList<FileInfo> fileInfoList = new LinkedList<FileInfo>();
        if (fileNodes != null) {
            Iterator it = fileNodes.iterator();
            while (it.hasNext()) {
                FileInfo file = new FileInfo();
                Node fileNode = (Node)it.next();
                if (fileNode.selectSingleNode("msr") == null) continue;
                file.initFromNode(fileNode, content);
                if (!file.isContentSet(content)) continue;
                fileInfoList.add(file);
            }
        }
        return fileInfoList;
    }

    public boolean isContentSet(int content) {
        boolean result = false;
        if (content == 1) {
            result = !this.getViolations().equals("0");
        } else if (content == 2) {
            result = !this.getComplexity().equals("0");
        } else if (content == 3) {
            result = !this.getDuplicatedLines().equals("0");
        }
        return result;
    }

    public String getKey() {
        return this.key;
    }

    public String getViolations() {
        return this.violations;
    }

    public String getComplexity() {
        return this.complexity;
    }

    public String getName() {
        return this.name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setViolations(String violations) {
        this.violations = violations;
    }

    public void setComplexity(String complexity) {
        this.complexity = complexity;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDuplicatedLines() {
        return this.duplicatedLines;
    }

    public void setDuplicatedLines(String duplicatedLines) {
        this.duplicatedLines = duplicatedLines;
    }
}

