/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.report.pdf;

import com.lowagie.text.BadElementException;
import com.lowagie.text.ChapterAutoNumber;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.sonar.report.pdf.PDFReporter;
import org.sonar.report.pdf.Style;
import org.sonar.report.pdf.Toc;
import org.sonar.report.pdf.entity.FileInfo;
import org.sonar.report.pdf.entity.Project;
import org.sonar.report.pdf.entity.Rule;
import org.sonar.report.pdf.entity.exception.ReportException;

public class ExecutivePDFReporter
extends PDFReporter {
    private URL logo;
    private String projectKey;
    private String sonarUrl;
    private Properties configProperties;
    private Properties langProperties;

    public ExecutivePDFReporter(URL logo, String projectKey, String sonarUrl, Properties configProperties, Properties langProperties) {
        this.logo = logo;
        this.projectKey = projectKey;
        this.sonarUrl = sonarUrl;
        this.configProperties = configProperties;
        this.langProperties = langProperties;
        reportType = "executive";
    }

    protected URL getLogo() {
        return this.logo;
    }

    protected String getProjectKey() {
        return this.projectKey;
    }

    protected String getSonarUrl() {
        return this.sonarUrl;
    }

    protected Properties getLangProperties() {
        return this.langProperties;
    }

    protected Properties getReportProperties() {
        return this.configProperties;
    }

    protected void printFrontPage(Document frontPageDocument, PdfWriter frontPageWriter) throws org.dom4j.DocumentException, ReportException {
        try {
            URL largeLogo = super.getConfigProperty("front.page.logo").startsWith("http://") ? new URL(super.getConfigProperty("front.page.logo")) : this.getClass().getClassLoader().getResource(super.getConfigProperty("front.page.logo"));
            Image logoImage = Image.getInstance((URL)largeLogo);
            logoImage.scaleAbsolute(360.0f, 200.0f);
            Rectangle pageSize = frontPageDocument.getPageSize();
            logoImage.setAbsolutePosition(114.0f, 542.0f);
            frontPageDocument.add((Element)logoImage);
            PdfPTable title = new PdfPTable(1);
            title.getDefaultCell().setHorizontalAlignment(1);
            title.getDefaultCell().setBorder(0);
            String projectRow = super.getProject().getName();
            String versionRow = super.getProject().getMeasures().getVersion();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String dateRow = df.format(super.getProject().getMeasures().getDate());
            String descriptionRow = super.getProject().getDescription();
            title.addCell(new Phrase(projectRow, Style.FRONTPAGE_FONT_1));
            title.addCell(new Phrase(versionRow, Style.FRONTPAGE_FONT_1));
            title.addCell(new Phrase(descriptionRow, Style.FRONTPAGE_FONT_2));
            title.addCell(new Phrase(super.getProject().getMeasure("profile").getDataValue(), Style.FRONTPAGE_FONT_3));
            title.addCell(new Phrase(dateRow, Style.FRONTPAGE_FONT_3));
            title.setTotalWidth(pageSize.getWidth() - frontPageDocument.leftMargin() - frontPageDocument.rightMargin());
            title.writeSelectedRows(0, -1, frontPageDocument.leftMargin(), 392.0f, frontPageWriter.getDirectContent());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadElementException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    protected void printPdfBody(Document document) throws DocumentException, IOException, org.dom4j.DocumentException, ReportException {
        Project project = super.getProject();
        ChapterAutoNumber chapter1 = new ChapterAutoNumber(new Paragraph(project.getName(), Style.CHAPTER_FONT));
        chapter1.add((Object)new Paragraph(this.getTextProperty("main.text.misc.overview"), Style.NORMAL_FONT));
        Section section11 = chapter1.addSection(new Paragraph(this.getTextProperty("general.report_overview"), Style.TITLE_FONT));
        this.printDashboard(project, section11);
        Section section12 = chapter1.addSection(new Paragraph(this.getTextProperty("general.violations_analysis"), Style.TITLE_FONT));
        this.printMostViolatedRules(project, section12);
        this.printMostViolatedFiles(project, section12);
        this.printMostComplexFiles(project, section12);
        this.printMostDuplicatedFiles(project, section12);
        document.add((Element)chapter1);
        for (Project subproject : project.getSubprojects()) {
            ChapterAutoNumber chapterN = new ChapterAutoNumber(new Paragraph(subproject.getName(), Style.CHAPTER_FONT));
            Section sectionN1 = chapterN.addSection(new Paragraph(this.getTextProperty("general.report_overview"), Style.TITLE_FONT));
            this.printDashboard(subproject, sectionN1);
            Section sectionN2 = chapterN.addSection(new Paragraph(this.getTextProperty("general.violations_analysis"), Style.TITLE_FONT));
            this.printMostViolatedRules(subproject, sectionN2);
            this.printMostViolatedFiles(subproject, sectionN2);
            this.printMostComplexFiles(subproject, sectionN2);
            this.printMostDuplicatedFiles(subproject, sectionN2);
            document.add((Element)chapterN);
        }
    }

    protected void printDashboard(Project project, Section section) throws DocumentException {
        Paragraph staticAnalysis = new Paragraph(this.getTextProperty("general.static_analysis"), Style.UNDERLINED_FONT);
        PdfPTable staticAnalysisTable = new PdfPTable(3);
        staticAnalysisTable.getDefaultCell().setBorderColor(Color.WHITE);
        PdfPTable linesOfCode = new PdfPTable(1);
        Style.noBorderTable(linesOfCode);
        linesOfCode.addCell(new Phrase(this.getTextProperty("general.lines_of_code"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable linesOfCodeTendency = new PdfPTable(2);
        Style.noBorderTable(linesOfCodeTendency);
        linesOfCodeTendency.getDefaultCell().setFixedHeight(20.0f);
        linesOfCodeTendency.addCell(new Phrase(project.getMeasure("ncloc").getFormatValue(), Style.DASHBOARD_DATA_FONT));
        linesOfCodeTendency.addCell(this.getTendencyImage(project.getMeasure("ncloc").getQualitativeTendency(), project.getMeasure("ncloc").getQuantitativeTendency()));
        linesOfCode.addCell(linesOfCodeTendency);
        linesOfCode.addCell(new Phrase(project.getMeasure("packages").getFormatValue() + " packages", Style.DASHBOARD_DATA_FONT_2));
        linesOfCode.addCell(new Phrase(project.getMeasure("classes").getFormatValue() + " classes", Style.DASHBOARD_DATA_FONT_2));
        linesOfCode.addCell(new Phrase(project.getMeasure("functions").getFormatValue() + " methods", Style.DASHBOARD_DATA_FONT_2));
        linesOfCode.addCell(new Phrase(project.getMeasure("duplicated_lines_density").getFormatValue() + " duplicated lines", Style.DASHBOARD_DATA_FONT_2));
        PdfPTable comments = new PdfPTable(1);
        Style.noBorderTable(comments);
        comments.addCell(new Phrase(this.getTextProperty("general.comments"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable commentsTendency = new PdfPTable(2);
        commentsTendency.getDefaultCell().setFixedHeight(20.0f);
        Style.noBorderTable(commentsTendency);
        commentsTendency.addCell(new Phrase(project.getMeasure("comment_lines_density").getFormatValue(), Style.DASHBOARD_DATA_FONT));
        commentsTendency.addCell(this.getTendencyImage(project.getMeasure("comment_lines_density").getQualitativeTendency(), project.getMeasure("comment_lines_density").getQuantitativeTendency()));
        comments.addCell(commentsTendency);
        comments.addCell(new Phrase(project.getMeasure("comment_lines").getFormatValue() + " comment lines", Style.DASHBOARD_DATA_FONT_2));
        PdfPTable complexity = new PdfPTable(1);
        Style.noBorderTable(complexity);
        complexity.addCell(new Phrase(this.getTextProperty("general.complexity"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable complexityTendency = new PdfPTable(2);
        complexityTendency.getDefaultCell().setFixedHeight(20.0f);
        Style.noBorderTable(complexityTendency);
        complexityTendency.addCell(new Phrase(project.getMeasure("function_complexity").getFormatValue(), Style.DASHBOARD_DATA_FONT));
        complexityTendency.addCell(this.getTendencyImage(project.getMeasure("function_complexity").getQualitativeTendency(), project.getMeasure("function_complexity").getQuantitativeTendency()));
        complexity.addCell(complexityTendency);
        complexity.addCell(new Phrase(project.getMeasure("class_complexity").getFormatValue() + " /class", Style.DASHBOARD_DATA_FONT_2));
        complexity.addCell(new Phrase(project.getMeasure("complexity").getFormatValue() + " decision points", Style.DASHBOARD_DATA_FONT_2));
        staticAnalysisTable.setSpacingBefore(10.0f);
        staticAnalysisTable.addCell(linesOfCode);
        staticAnalysisTable.addCell(comments);
        staticAnalysisTable.addCell(complexity);
        staticAnalysisTable.setSpacingAfter(20.0f);
        Paragraph dynamicAnalysis = new Paragraph(this.getTextProperty("general.dynamic_analysis"), Style.UNDERLINED_FONT);
        PdfPTable dynamicAnalysisTable = new PdfPTable(3);
        Style.noBorderTable(dynamicAnalysisTable);
        PdfPTable codeCoverage = new PdfPTable(1);
        Style.noBorderTable(codeCoverage);
        codeCoverage.addCell(new Phrase(this.getTextProperty("general.code_coverage"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable codeCoverageTendency = new PdfPTable(2);
        Style.noBorderTable(codeCoverageTendency);
        codeCoverageTendency.getDefaultCell().setFixedHeight(20.0f);
        codeCoverageTendency.addCell(new Phrase(project.getMeasure("coverage").getFormatValue() + " coverage", Style.DASHBOARD_DATA_FONT));
        codeCoverageTendency.addCell(this.getTendencyImage(project.getMeasure("coverage").getQualitativeTendency(), project.getMeasure("coverage").getQuantitativeTendency()));
        codeCoverage.addCell(codeCoverageTendency);
        codeCoverage.addCell(new Phrase(project.getMeasure("tests").getFormatValue() + " tests", Style.DASHBOARD_DATA_FONT_2));
        PdfPTable testSuccess = new PdfPTable(1);
        Style.noBorderTable(testSuccess);
        testSuccess.addCell(new Phrase(this.getTextProperty("general.test_success"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable testSuccessTendency = new PdfPTable(2);
        Style.noBorderTable(testSuccessTendency);
        testSuccessTendency.getDefaultCell().setFixedHeight(20.0f);
        testSuccessTendency.addCell(new Phrase(project.getMeasure("test_success_density").getFormatValue(), Style.DASHBOARD_DATA_FONT));
        testSuccessTendency.addCell(this.getTendencyImage(project.getMeasure("test_success_density").getQualitativeTendency(), project.getMeasure("test_success_density").getQuantitativeTendency()));
        testSuccess.addCell(testSuccessTendency);
        testSuccess.addCell(new Phrase(project.getMeasure("test_failures").getFormatValue() + " failures", Style.DASHBOARD_DATA_FONT_2));
        testSuccess.addCell(new Phrase(project.getMeasure("test_errors").getFormatValue() + " errors", Style.DASHBOARD_DATA_FONT_2));
        dynamicAnalysisTable.setSpacingBefore(10.0f);
        dynamicAnalysisTable.addCell(codeCoverage);
        dynamicAnalysisTable.addCell(testSuccess);
        dynamicAnalysisTable.addCell("");
        dynamicAnalysisTable.setSpacingAfter(20.0f);
        Paragraph codingRulesViolations = new Paragraph(this.getTextProperty("general.coding_rules_violations"), Style.UNDERLINED_FONT);
        PdfPTable codingRulesViolationsTable = new PdfPTable(3);
        Style.noBorderTable(codingRulesViolationsTable);
        PdfPTable rulesCompliance = new PdfPTable(1);
        Style.noBorderTable(rulesCompliance);
        rulesCompliance.addCell(new Phrase(this.getTextProperty("general.rules_compliance"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable rulesComplianceTendency = new PdfPTable(2);
        Style.noBorderTable(rulesComplianceTendency);
        rulesComplianceTendency.getDefaultCell().setFixedHeight(20.0f);
        rulesComplianceTendency.addCell(new Phrase(project.getMeasure("violations_density").getFormatValue(), Style.DASHBOARD_DATA_FONT));
        Image tendencyRulesResize = this.getTendencyImage(project.getMeasure("violations_density").getQualitativeTendency(), project.getMeasure("violations_density").getQuantitativeTendency());
        tendencyRulesResize.scaleAbsolute(20.0f, 20.0f);
        PdfPCell tendencyRulesCell = new PdfPCell(tendencyRulesResize);
        tendencyRulesCell.setBorder(0);
        rulesComplianceTendency.addCell(tendencyRulesCell);
        rulesCompliance.addCell(rulesComplianceTendency);
        PdfPTable violations = new PdfPTable(1);
        Style.noBorderTable(violations);
        violations.addCell(new Phrase(this.getTextProperty("general.violations"), Style.DASHBOARD_TITLE_FONT));
        PdfPTable violationsTendency = new PdfPTable(2);
        Style.noBorderTable(violationsTendency);
        violationsTendency.getDefaultCell().setFixedHeight(20.0f);
        violationsTendency.addCell(new Phrase(project.getMeasure("violations").getFormatValue(), Style.DASHBOARD_DATA_FONT));
        Image tendencyResize = this.getTendencyImage(project.getMeasure("violations").getQualitativeTendency(), project.getMeasure("violations").getQuantitativeTendency());
        tendencyResize.scaleAbsolute(20.0f, 20.0f);
        PdfPCell tendencyCell = new PdfPCell(tendencyResize);
        tendencyCell.setBorder(0);
        violationsTendency.addCell(tendencyCell);
        violations.addCell(violationsTendency);
        codingRulesViolationsTable.setSpacingBefore(10.0f);
        codingRulesViolationsTable.addCell(rulesCompliance);
        codingRulesViolationsTable.addCell(violations);
        codingRulesViolationsTable.addCell("");
        codingRulesViolationsTable.setSpacingAfter(20.0f);
        section.add((Object)Chunk.NEWLINE);
        section.add((Object)staticAnalysis);
        section.add((Object)staticAnalysisTable);
        section.add((Object)dynamicAnalysis);
        section.add((Object)dynamicAnalysisTable);
        section.add((Object)codingRulesViolations);
        section.add((Object)codingRulesViolationsTable);
    }

    protected void printMostDuplicatedFiles(Project project, Section section) {
        List<FileInfo> files = project.getMostDuplicatedFiles();
        Iterator<FileInfo> it = files.iterator();
        LinkedList<String> left = new LinkedList<String>();
        LinkedList<String> right = new LinkedList<String>();
        while (it.hasNext()) {
            FileInfo file = it.next();
            left.add(file.getName());
            right.add(file.getDuplicatedLines());
        }
        PdfPTable mostDuplicatedFilesTable = Style.createSimpleTable(left, right, this.getTextProperty("general.most_duplicated_files"), this.getTextProperty("general.no_duplicated_files"));
        section.add((Object)mostDuplicatedFilesTable);
    }

    protected void printMostComplexFiles(Project project, Section section) {
        List<FileInfo> files = project.getMostComplexFiles();
        Iterator<FileInfo> it = files.iterator();
        LinkedList<String> left = new LinkedList<String>();
        LinkedList<String> right = new LinkedList<String>();
        while (it.hasNext()) {
            FileInfo file = it.next();
            left.add(file.getName());
            right.add(file.getComplexity());
        }
        PdfPTable mostComplexFilesTable = Style.createSimpleTable(left, right, this.getTextProperty("general.most_complex_files"), this.getTextProperty("general.no_complex_files"));
        section.add((Object)mostComplexFilesTable);
    }

    protected void printMostViolatedRules(Project project, Section section) {
        List<Rule> mostViolatedRules = project.getMostViolatedRules();
        Iterator<Rule> it = mostViolatedRules.iterator();
        LinkedList<String> left = new LinkedList<String>();
        LinkedList<String> right = new LinkedList<String>();
        for (int limit = 0; it.hasNext() && limit < 5; ++limit) {
            Rule rule = it.next();
            left.add(rule.getName());
            right.add(String.valueOf(rule.getViolationsNumberFormatted()));
        }
        PdfPTable mostViolatedRulesTable = Style.createSimpleTable(left, right, this.getTextProperty("general.most_violated_rules"), this.getTextProperty("general.no_violated_rules"));
        section.add((Object)mostViolatedRulesTable);
    }

    protected void printMostViolatedFiles(Project project, Section section) {
        List<FileInfo> files = project.getMostViolatedFiles();
        Iterator<FileInfo> it = files.iterator();
        LinkedList<String> left = new LinkedList<String>();
        LinkedList<String> right = new LinkedList<String>();
        while (it.hasNext()) {
            FileInfo file = it.next();
            left.add(file.getName());
            right.add(file.getViolations());
        }
        PdfPTable mostViolatedFilesTable = Style.createSimpleTable(left, right, this.getTextProperty("general.most_violated_files"), this.getTextProperty("general.no_violated_files"));
        section.add((Object)mostViolatedFilesTable);
    }

    protected void printTocTitle(Toc tocDocument) throws DocumentException {
        Paragraph tocTitle = new Paragraph(super.getTextProperty("main.table.of.contents"), Style.TOC_TITLE_FONT);
        tocTitle.setAlignment(1);
        tocDocument.getTocDocument().add((Element)tocTitle);
        tocDocument.getTocDocument().add((Element)Chunk.NEWLINE);
    }
}

