/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.manager;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.manager.AbstractComponentManager;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.lifecycle.LifecycleHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonComponentManager<T>
extends AbstractComponentManager<T> {
    private boolean disposed;
    private Future<T> singletonFuture;

    public SingletonComponentManager(MutablePlexusContainer container, LifecycleHandler lifecycleHandler, ComponentDescriptor<T> componentDescriptor) {
        super(container, lifecycleHandler, componentDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void dispose() throws ComponentLifecycleException {
        T singleton;
        SingletonComponentManager singletonComponentManager = this;
        synchronized (singletonComponentManager) {
            this.disposed = true;
            singleton = this.getExistingInstance(true);
        }
        if (singleton != null) {
            this.destroyInstance(singleton);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getComponent() throws ComponentInstantiationException, ComponentLifecycleException {
        FutureTask<T> singletonFuture;
        Object singleton;
        SingletonComponentManager singletonComponentManager = this;
        synchronized (singletonComponentManager) {
            if (this.disposed) {
                throw new ComponentLifecycleException("This ComponentManager has already been destroyed");
            }
            singleton = this.getExistingInstance(false);
            if (singleton != null) {
                return singleton;
            }
            singletonFuture = new FutureTask<T>(new CreateInstance());
            this.singletonFuture = singletonFuture;
        }
        if (singletonFuture != null) {
            singletonFuture.run();
        }
        try {
            return singletonFuture.get();
        }
        catch (Exception e) {
            singleton = this;
            synchronized (singleton) {
                if (this.singletonFuture == singletonFuture) {
                    this.singletonFuture = null;
                }
            }
            Throwable cause = e;
            if (e instanceof ExecutionException && e.getCause() != null) {
                cause = e.getCause();
            }
            if (cause instanceof ComponentInstantiationException) {
                throw (ComponentInstantiationException)cause;
            }
            if (cause instanceof ComponentLifecycleException) {
                throw (ComponentLifecycleException)cause;
            }
            throw new ComponentLifecycleException("Unexpected error obtaining singleton instance", cause);
        }
    }

    @Override
    public void release(Object component) throws ComponentLifecycleException {
        T singleton = this.getExistingInstance(true);
        if (singleton != null) {
            this.destroyInstance(singleton);
        }
    }

    public synchronized String toString() {
        T singleton = this.getExistingInstance(false);
        return "SingletonComponentManager[" + singleton == null ? this.getComponentDescriptor().getImplementationClass().getName() : singleton + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private T getExistingInstance(boolean clearFuture) {
        SingletonComponentManager singletonComponentManager = this;
        synchronized (singletonComponentManager) {
            try {
                T t = this.singletonFuture.get();
                return t;
            }
            catch (Exception exception) {
            }
            finally {
                if (clearFuture) {
                    this.singletonFuture = null;
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateInstance
    implements Callable<T> {
        private CreateInstance() {
        }

        @Override
        public T call() throws Exception {
            return SingletonComponentManager.this.createInstance();
        }
    }
}

