/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.collections;

import com.google.common.base.ReferenceType;
import com.google.common.collect.ReferenceMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentDescriptorListener;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveList<T>
implements List<T> {
    private final MutablePlexusContainer container;
    private final Class<T> type;
    private final Set<String> roleHints;
    private final String hostComponent;
    private List<T> components = new ArrayList<T>();
    private List<String> componentHints = new ArrayList<String>();
    private boolean hasExternalReference;
    private final ConcurrentMap<ComponentDescriptor<? extends T>, T> componentsByDescriptor = new ReferenceMap(ReferenceType.STRONG, ReferenceType.WEAK);

    public LiveList(MutablePlexusContainer container, Class<T> type, List<String> roleHints, String hostComponent) {
        this.container = container;
        this.type = type;
        this.roleHints = roleHints == null ? null : Collections.unmodifiableSet(new LinkedHashSet<String>(roleHints));
        this.hostComponent = hostComponent;
        container.addComponentDescriptorListener(new LiveListDescriptorListener());
    }

    public String getHostComponent() {
        return this.hostComponent;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public synchronized int size() {
        return this.components.size();
    }

    @Override
    public synchronized T get(int index) {
        return this.components.get(index);
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.components.contains(o);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.components.containsAll(c);
    }

    @Override
    public synchronized int indexOf(Object o) {
        return this.components.indexOf(o);
    }

    @Override
    public synchronized int lastIndexOf(Object o) {
        return this.components.lastIndexOf(o);
    }

    @Override
    public synchronized List<T> subList(int fromIndex, int toIndex) {
        this.hasExternalReference = true;
        return Collections.unmodifiableList(this.components).subList(fromIndex, toIndex);
    }

    @Override
    public synchronized Iterator<T> iterator() {
        this.hasExternalReference = true;
        return Collections.unmodifiableList(this.components).iterator();
    }

    @Override
    public synchronized ListIterator<T> listIterator() {
        this.hasExternalReference = true;
        return Collections.unmodifiableList(this.components).listIterator();
    }

    @Override
    public synchronized ListIterator<T> listIterator(int index) {
        this.hasExternalReference = true;
        return Collections.unmodifiableList(this.components).listIterator(index);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.components.toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.components.toArray(a);
    }

    @Override
    public synchronized boolean equals(Object o) {
        return this == o || o instanceof List && ((Object)this.components).equals(o);
    }

    @Override
    public synchronized int hashCode() {
        return ((Object)this.components).hashCode();
    }

    public synchronized String toString() {
        return this.components.toString();
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object k) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    private synchronized void componentDescriptorAdded(ComponentDescriptor<? extends T> descriptor) {
        String roleHint = descriptor.getRoleHint();
        if (!this.componentsByDescriptor.containsKey(descriptor) && (this.roleHints == null || this.roleHints.contains(roleHint))) {
            Object component = null;
            try {
                component = this.container.lookup(descriptor);
            }
            catch (ComponentLookupException ignored) {
                // empty catch block
            }
            if (this.hasExternalReference) {
                this.components = new ArrayList<T>(this.components);
                this.hasExternalReference = false;
            }
            this.insertSorted(component, roleHint);
            this.componentsByDescriptor.put(descriptor, component);
        }
    }

    private synchronized void insertSorted(T targetComponent, String targetHint) {
        if (this.roleHints == null) {
            this.components.add(targetComponent);
            return;
        }
        Iterator<String> hintOrder = this.roleHints.iterator();
        ListIterator<String> componentIterator = this.componentHints.listIterator();
        while (componentIterator.hasNext()) {
            String currentHint = componentIterator.next();
            String nextHint = hintOrder.next();
            while (!nextHint.equals(currentHint)) {
                if (nextHint.equals(targetHint)) {
                    this.components.add(componentIterator.previousIndex(), targetComponent);
                    this.componentHints.add(componentIterator.previousIndex(), targetHint);
                    return;
                }
                nextHint = hintOrder.next();
            }
        }
        this.components.add(targetComponent);
        this.componentHints.add(targetHint);
    }

    private synchronized void componentDescriptorRemoved(ComponentDescriptor<? extends T> descriptor) {
        Object component = this.componentsByDescriptor.remove(descriptor);
        if (component != null) {
            if (this.hasExternalReference) {
                this.components = new ArrayList<T>(this.components);
                this.hasExternalReference = false;
            }
            Iterator<String> hintIterator = this.componentHints.iterator();
            Iterator<T> componentIterator = this.components.iterator();
            while (componentIterator.hasNext()) {
                T current = componentIterator.next();
                hintIterator.next();
                if (current != component) continue;
                componentIterator.remove();
                hintIterator.remove();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LiveListDescriptorListener
    implements ComponentDescriptorListener<T> {
        private LiveListDescriptorListener() {
        }

        @Override
        public Class<T> getType() {
            return LiveList.this.type;
        }

        @Override
        public List<String> getRoleHints() {
            if (LiveList.this.roleHints != null) {
                return new ArrayList<String>(LiveList.this.roleHints);
            }
            return null;
        }

        @Override
        public void componentDescriptorAdded(ComponentDescriptor<? extends T> descriptor) {
            LiveList.this.componentDescriptorAdded(descriptor);
        }

        @Override
        public void componentDescriptorRemoved(ComponentDescriptor<? extends T> descriptor) {
            LiveList.this.componentDescriptorRemoved(descriptor);
        }
    }
}

