/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ProtoXmlPlexusConfiguration
implements PlexusConfiguration {
    private String xml;
    private WeakReference configHolder;

    public ProtoXmlPlexusConfiguration(XmlPlexusConfiguration config) {
        this.store(config);
    }

    private synchronized void store(XmlPlexusConfiguration config) {
        this.xml = config.getXpp3Dom().toString();
        this.configHolder = new WeakReference<XmlPlexusConfiguration>(config);
    }

    public XmlPlexusConfiguration read() {
        XmlPlexusConfiguration config = this.configHolder == null ? null : this.configHolder.get();
        if (config == null) {
            try {
                config = new XmlPlexusConfiguration(Xpp3DomBuilder.build((Reader)new StringReader(this.xml)));
            }
            catch (XmlPullParserException e) {
                IllegalStateException error = new IllegalStateException("Failed to re-read stored XML plexus configuration.");
                error.initCause(e);
                throw error;
            }
            catch (IOException e) {
                IllegalStateException error = new IllegalStateException("Failed to re-read stored XML plexus configuration.");
                error.initCause(e);
                throw error;
            }
        }
        return config;
    }

    public void addChild(PlexusConfiguration configuration) {
        XmlPlexusConfiguration config = this.read();
        config.addChild(configuration);
        this.store(config);
    }

    public PlexusConfiguration addChild(String name) {
        XmlPlexusConfiguration config = this.read();
        PlexusConfiguration configuration = config.addChild(name);
        this.store(config);
        return configuration;
    }

    public PlexusConfiguration addChild(String name, String value) {
        XmlPlexusConfiguration config = this.read();
        PlexusConfiguration configuration = config.addChild(name).setValueAndGetSelf(value);
        this.store(config);
        return configuration;
    }

    public String getAttribute(String paramName) throws PlexusConfigurationException {
        return this.read().getAttribute(paramName);
    }

    public String getAttribute(String name, String defaultValue) {
        return this.read().getAttribute(name, defaultValue);
    }

    public String[] getAttributeNames() {
        return this.read().getAttributeNames();
    }

    public PlexusConfiguration getChild(String child) {
        return this.read().getChild(child);
    }

    public PlexusConfiguration getChild(int i) {
        return this.read().getChild(i);
    }

    public PlexusConfiguration getChild(String child, boolean createChild) {
        return this.read().getChild(child, createChild);
    }

    public int getChildCount() {
        return this.read().getChildCount();
    }

    public PlexusConfiguration[] getChildren() {
        return this.read().getChildren();
    }

    public PlexusConfiguration[] getChildren(String name) {
        return this.read().getChildren(name);
    }

    public String getName() {
        return this.read().getName();
    }

    public String getValue() throws PlexusConfigurationException {
        return this.read().getValue();
    }

    public void setValue(String value) {
        this.read().setValue(value);
    }

    public PlexusConfiguration setValueAndGetSelf(String value) {
        this.read().setValue(value);
        return this;
    }

    public String getValue(String defaultValue) {
        return this.read().getValue(defaultValue);
    }
}

